package cn.gtmap.realestate.supervise.server.rabbitmq;

import com.gtis.config.AppConfig;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

/**
 * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
 * @version 1.0, 2017/3/23
 * @description MQ链接配置
 */
@Configuration
@Profile(value = "rabbitMQ")
public class Connection {

    @Bean
    public ConnectionFactory connectionFactory() {
        CachingConnectionFactory connectionFactory = new CachingConnectionFactory();
        String address = AppConfig.getProperty("supervise.rabbitmq.address");
        String username = AppConfig.getProperty("supervise.rabbitmq.name");
        String passwrod = AppConfig.getProperty("supervise.rabbitmq.password");
        String virtual = AppConfig.getProperty("supervise.rabbitmq.virtualhost");

        connectionFactory.setAddresses(address);
        connectionFactory.setUsername(username);
        connectionFactory.setPassword(passwrod);
        connectionFactory.setVirtualHost(virtual);
        connectionFactory.setPublisherConfirms(true); //必须要设置
        return connectionFactory;
    }
}
