package cn.gtmap.realestate.supervise.server.quartz.sftp;

import cn.gtmap.realestate.supervise.server.sftp.SftpService;
import cn.gtmap.realestate.supervise.server.sftp.WatchDirService;
import com.gtis.config.AppConfig;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.stereotype.Component;

import java.io.File;

/**
 * @author <a href="mailto:gaofeng@gtmap.cn">gaofeng</a>
 * @version 1.0, 2017/2/13
 * @description 定时取响应报文配置
 */
@Component
@Configurable
public class RecieveSftpRespScheduledTasks {

    private static final Logger LOGGER = LoggerFactory.getLogger(RecieveSftpRespScheduledTasks.class);

    private static final String sftpBizBakPath = AppConfig.getProperty("supervise.sftp.biz.bak.path");

    private boolean cornFlag = true;

    @Autowired
    SftpService sftpService;

    @Autowired
    WatchDirService watchService;

    public void reciveRespFile() {
        if (cornFlag) {
            cornFlag = false;
            try {
                LOGGER.info("取报部响应报文定时任务开始执行");
                File file = new File(sftpBizBakPath);
                if (!file.exists()) {
                    file.mkdirs();
                }
                if (file.isDirectory()) {
                    String[] files = file.list();
                    for (String fileName : files) {
                        if (fileName.endsWith("xml")) {
                            LOGGER.info("取报部响应报文文件名称开始，报文名称:{}", fileName);
                            String resString = sftpService.sshSftp2RecFile(fileName);
                            if (StringUtils.isNotBlank(resString)) {
                                //文件删除
                                File fileBakPath = new File(sftpBizBakPath + fileName);
                                boolean flagRep = watchService.updateSftpRzjl(fileName, resString);//更新上报日志
                                if (flagRep && fileBakPath.exists()) {
                                    boolean flag = fileBakPath.delete();
                                    LOGGER.info("删除上报报文Bak路径文件结果:{}，文件名:{}", flag, fileName);
                                }
                            }
                            LOGGER.info("取报部响应报文结束，文件名称:{}", fileName);
                        }
                    }
                }
            } catch (Exception e) {
                LOGGER.error("RecieveSftpRespScheduledTasks.Exception in!{}", e);
                cornFlag = true;
            }
            cornFlag = true;
        }
    }
}

