package cn.gtmap.realestate.supervise.server.quartz.sftp;


import cn.gtmap.estateplat.core.ex.AppException;
import com.gtis.config.AppConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.expression.ParseException;
import org.springframework.scheduling.quartz.CronTriggerFactoryBean;
import org.springframework.scheduling.quartz.MethodInvokingJobDetailFactoryBean;

/**
 * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
 * @version 1.0, 2017/2/13
 * @description 定时器配置
 */
@Configuration
@Import({RecieveSftpRespScheduledTasks.class})
public class RecieveSftpRespSchedledConfig {

    private static final Logger LOGGER = LoggerFactory.getLogger(RecieveSftpRespSchedledConfig.class);

    @Autowired
    RecieveSftpRespScheduledTasks recieveSftpRespScheduledTasks;

    private String cronTime = AppConfig.getProperty("reciveSftpRespCronTime");
    // 配置中设定了 0 0 12 * * ?
    // ① targetMethod: 指定需要定时执行scheduleInfoAction中的simpleJobTest()方法
    // ② concurrent：对于相同的JobDetail，当指定多个Trigger时, 很可能第一个job完成之前，
    // 第二个job就开始了。指定concurrent设为false，多个job不会并发运行，第二个job将不会在第一个job完成之前开始。
    // ③ cronExpression：0/10 * * * * ?表示每10秒执行一次，具体可参考附表。
    // ④ triggers：通过再添加其他的ref元素可在list中放置多个触发器。 scheduleInfoAction中的simpleJobTest()方法

    @Bean
    public MethodInvokingJobDetailFactoryBean reviceRespFileFactoryBean() {
        MethodInvokingJobDetailFactoryBean bean = new MethodInvokingJobDetailFactoryBean();
        bean.setTargetObject(recieveSftpRespScheduledTasks);
        bean.setTargetMethod("reciveRespFile");
        bean.setConcurrent(false);
        return bean;
    }

    @Bean
    public CronTriggerFactoryBean reviceRespFileCronTriggerBean() {
        CronTriggerFactoryBean tigger = new CronTriggerFactoryBean();
        tigger.setJobDetail(reviceRespFileFactoryBean().getObject());
        try {
            tigger.setCronExpression(cronTime);//每5秒执行一次
        } catch (ParseException e) {
            LOGGER.error("RecieveSftpRespSchedledConfig.reviceRespFileCronTriggerBean.ParseException in!{}",e);
            throw new AppException(e, 2009);
        }
        return tigger;

    }
}
