package cn.gtmap.realestate.supervise.server.quartz;

import cn.gtmap.realestate.supervise.server.common.impl.DataInsertDbService;
import cn.gtmap.realestate.supervise.server.quartz.failresp.RecieveFailRespSchedledConfig;
import cn.gtmap.realestate.supervise.server.quartz.graphicservice.GraphicZdSchedledConfig;
import cn.gtmap.realestate.supervise.server.quartz.graphicservice.GraphicZhSchedledConfig;
import cn.gtmap.realestate.supervise.server.quartz.jrrz.JrrzScheduledConfig;
import cn.gtmap.realestate.supervise.server.quartz.kxltj.KxltjScheduledConfig;
import cn.gtmap.realestate.supervise.server.quartz.rabbitmqinfo.RabbitInfoSchedledConfig;
import cn.gtmap.realestate.supervise.server.quartz.sftp.RecieveSftpRespSchedledConfig;
import com.gtis.config.AppConfig;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;

/**
 * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
 * @version 1.0, 2017/7/24
 * @description
 */
@Configuration
public class schedulerFactoryBeanConfig implements ApplicationContextAware {

    @Autowired
    GraphicZdSchedledConfig graphicZdSchedledConfig;

    @Autowired
    GraphicZhSchedledConfig graphicZhSchedledConfig;

    RabbitInfoSchedledConfig rabbitInfoSchedledConfig;

    @Autowired
    RecieveSftpRespSchedledConfig recieveSftpRespSchedledConfig;

    @Autowired
    RecieveFailRespSchedledConfig recieveFailRespSchedledConfig;

    @Autowired
    JrrzScheduledConfig jrrzScheduledConfig;

    @Autowired
    private DataInsertDbService dataInsertDbService;

    @Autowired
    KxltjScheduledConfig kxltjScheduledConfig;

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @description 判断是否开启定时上图任务
     */
    String istrue = AppConfig.getProperty("supervise.isGraphic");

    //上下文变量
    private ApplicationContext applicationContext;


    /**
     * @param
     * @return 开启定时器任务
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @description 判断是否开启定时上图任务，如果开启，将定时任务启动
     */
    @Bean
    public SchedulerFactoryBean schedulerFactory() {
        SchedulerFactoryBean bean = new SchedulerFactoryBean();
        boolean envFlag = dataInsertDbService.getEnv();
        if ("true".equals(istrue)) {
            if (!envFlag) {
                if (null == rabbitInfoSchedledConfig) {
                    rabbitInfoSchedledConfig = getApplicationContext().getBean(RabbitInfoSchedledConfig.class);
                }
                bean.setTriggers(graphicZdSchedledConfig.graphicZdServiceCronTriggerBean().getObject(),
                        graphicZhSchedledConfig.graphicZhServiceCronTriggerBean().getObject(),
                        rabbitInfoSchedledConfig.RabbitInfoServiceCronTriggerBean().getObject(),
                        recieveSftpRespSchedledConfig.reviceRespFileCronTriggerBean().getObject(),
                        recieveFailRespSchedledConfig.reviceRespFailFileCronTriggerBean().getObject(),
                        jrrzScheduledConfig.jrrzServiceCronTriggerBean().getObject(),
                        kxltjScheduledConfig.kxtjServiceCronTriggerBean().getObject());
            } else {
                bean.setTriggers(graphicZdSchedledConfig.graphicZdServiceCronTriggerBean().getObject(),
                        graphicZhSchedledConfig.graphicZhServiceCronTriggerBean().getObject(),
                        recieveSftpRespSchedledConfig.reviceRespFileCronTriggerBean().getObject(),
                        recieveFailRespSchedledConfig.reviceRespFailFileCronTriggerBean().getObject(),
                        jrrzScheduledConfig.jrrzServiceCronTriggerBean().getObject(),
                        kxltjScheduledConfig.kxtjServiceCronTriggerBean().getObject());
            }
        } else {
            if (!envFlag) {
                if (null == rabbitInfoSchedledConfig) {
                    rabbitInfoSchedledConfig = getApplicationContext().getBean(RabbitInfoSchedledConfig.class);
                }
                bean.setTriggers(rabbitInfoSchedledConfig.RabbitInfoServiceCronTriggerBean().getObject(),
                        recieveSftpRespSchedledConfig.reviceRespFileCronTriggerBean().getObject(),
                        recieveFailRespSchedledConfig.reviceRespFailFileCronTriggerBean().getObject(),
                        jrrzScheduledConfig.jrrzServiceCronTriggerBean().getObject(),
                        kxltjScheduledConfig.kxtjServiceCronTriggerBean().getObject());
            } else {
                bean.setTriggers(
                        recieveSftpRespSchedledConfig.reviceRespFileCronTriggerBean().getObject(),
                        recieveFailRespSchedledConfig.reviceRespFailFileCronTriggerBean().getObject(),
                        jrrzScheduledConfig.jrrzServiceCronTriggerBean().getObject(),
                        kxltjScheduledConfig.kxtjServiceCronTriggerBean().getObject());
            }
        }
        return bean;
    }


    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public ApplicationContext getApplicationContext() {
        return applicationContext;
    }
}
