package cn.gtmap.realestate.supervise.server.quartz.rabbitmqinfo;

import cn.gtmap.realestate.supervise.server.entity.ClientInfo;
import cn.gtmap.realestate.supervise.server.model.RabbitMqNodeInfo;
import cn.gtmap.realestate.supervise.server.model.RabbitMqOverView;
import cn.gtmap.realestate.supervise.server.model.RabbitmqClientQueueInfo;
import cn.gtmap.realestate.supervise.server.model.RabbitmqQueueInfo;
import cn.gtmap.realestate.supervise.server.rabbitmq.RabbitMqInfoContain;
import cn.gtmap.realestate.supervise.server.rabbitmq.RabbitServerConfig;
import cn.gtmap.realestate.supervise.server.rabbitmq.RabbitServerInfo;
import cn.gtmap.realestate.supervise.server.service.ClientInfoService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.gtis.config.AppConfig;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.util.List;
import java.util.Map;


/**
 * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
 * @version 1.0, 2017/2/13
 * @description 定时器启动到指定文件夹下获取数据并上传到消费接受中心
 */
@Component
@Configurable
@Profile(value = "rabbitMQ")
public class RabbitMqInfoScheduledTasks {

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @description 上图服务
     */
    @Autowired
    RabbitServerInfo rabbitServerInfo;

    @Autowired
    RabbitMqInfoContain rabbitMqInfoContain;


    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @param
     * @return 某个队列的信息
     * @description 查看消息队列信息
     */

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @description rabbtimq名称
     */
    String name = AppConfig.getProperty("supervise.rabbitmq.name");

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @description rabbitmq 用户密码
     */
    String password = AppConfig.getProperty("supervise.rabbitmq.password");

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @description rabbitmq 地址
     */
    String address = AppConfig.getProperty("supervise.rabbitmq.address");

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @description rabbitmq 空间
     */
    String virtualHost = AppConfig.getProperty("supervise.rabbitmq.virtualhost");

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @description 需要监听的队列名称
     */
    String queue = AppConfig.getProperty("supervise.rabbitmq.queue");


    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @description 需要查看的消息队列信息
     */
    RabbitServerConfig rabbitServerConfig = new RabbitServerConfig();

    @Autowired
    ClientInfoService clientInfoService;

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @param
     * @return void
     * @description 定时获取RabbitMq 服务器信息
     */
    public void rabbitMqInfo() throws IOException, InterruptedException {

        initQueueInfos();

        RabbitmqQueueInfo queueInfo = rabbitServerInfo.getRabbitMqInfo(rabbitServerConfig, queue);

        RabbitMqOverView overViewInfo = rabbitServerInfo.getRabbitMqOverView(rabbitServerConfig);

        RabbitMqNodeInfo nodeInfo = rabbitServerInfo.getRabbitMqNodeInfo(rabbitServerConfig, overViewInfo.getCluster_name());


        while(rabbitMqInfoContain.isRead()) {
            Thread.sleep(10000l);
        }

        rabbitMqInfoContain.setRabbitMqNodeInfo(nodeInfo);

        rabbitMqInfoContain.setRabbitMqOverView(overViewInfo);

        rabbitMqInfoContain.setRabbitmqQueueInfo(queueInfo);

    }


    private void initQueueInfos() {

        rabbitServerConfig.setAddress(address);

        rabbitServerConfig.setName(name);

        rabbitServerConfig.setPassword(password);

        rabbitServerConfig.setVirtualHost(virtualHost);

    }

    public RabbitServerConfig getRabbitServerConfig() {
        return rabbitServerConfig;
    }

    public void setRabbitServerConfig(RabbitServerConfig rabbitServerConfig) {
        this.rabbitServerConfig = rabbitServerConfig;
    }
}

