package cn.gtmap.realestate.supervise.server.quartz.kxltj;

import cn.gtmap.realestate.supervise.entity.XtRegion;
import cn.gtmap.realestate.supervise.server.dao.mapper.BaKxtjMapper;
import cn.gtmap.realestate.supervise.server.dao.mapper.BaRzjlMapper;
import cn.gtmap.realestate.supervise.server.dao.mapper.BaSftpMapper;
import cn.gtmap.realestate.supervise.server.entity.Rzjl;
import cn.gtmap.realestate.supervise.server.service.impl.TszdkxlServiceImpl;
import cn.gtmap.realestate.supervise.server.utils.TimeUtils;
import com.google.common.collect.Maps;
import com.gtis.config.AppConfig;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:gaofeng@gtmap.cn">gaofeng</a>
 * @version 1.0, 2018/8/3
 * @description 空项率统计
 */
@Component
public class KxltjScheduledTask {

    private static final Logger LOGGER = LoggerFactory.getLogger(KxltjScheduledTask.class);

    @Autowired
    private BaKxtjMapper baKxtjMapper;

    @Autowired
    private BaRzjlMapper baRzjlMapper;

    @Autowired
    private BaSftpMapper baSftpMapper;

    @Autowired
    private TszdkxlServiceImpl tszdkxlService;

    private String cronFlag = AppConfig.getProperty("supersive.kxtj.cron.flag");//true:执行，false：不执行

    private boolean flag = true;

    /**
     * 空项统计业务逻辑
     */
    public void handleKx() {

        if (StringUtils.equals("true", cronFlag)) {
            if (flag) {
                flag = false;
                try {
                    LOGGER.info("空项率统计定时任务启动");
                    Date maxDate = baKxtjMapper.getMaxDate();
                    int days = TimeUtils.differentDays(maxDate, new Date());//两个日期天数
                    Map<String, Object> params = Maps.newHashMap();
                    for (int i = 1; i < days; i++) {
                        Date addDate = TimeUtils.getAddDate(maxDate, i);
                        params.put("startDate", TimeUtils.dateToStr(addDate, "yyyyMMdd"));
                        params.put("endDate", TimeUtils.dateToStr(addDate, "yyyyMMdd"));
                        List<Rzjl> ywhList = baRzjlMapper.getYwhList(params);
                        List<Map<String, Object>> fdcq = baSftpMapper.getFdcq1List(params);
                        List<Map<String, Object>> dyaq = baSftpMapper.getDyaqList(params);
                        List<XtRegion> qxxxList = baKxtjMapper.getXjxx();
                        for (XtRegion xtRegion : qxxxList) {
                            String qhdm = xtRegion.getQhdm();
                            String qhmc = xtRegion.getQhmc();
                            Map<String, Object> countMap = tszdkxlService.getQxtjxx(qhdm, qhmc, ywhList, fdcq, dyaq);//区县当天统计数据
                            if (null == countMap || countMap.isEmpty()) {
                                countMap = Maps.newHashMap();
                                countMap.put("qhdm", qhdm);
                                countMap.put("bdcdjzmh", "0");
                                countMap.put("djlx", "0");
                                countMap.put("bdcqzh", "0");
                                countMap.put("bdcdyh", "0");
                                countMap.put("djsj", "0");
                                countMap.put("ghyt", "0");
                                countMap.put("gyfs", "0");
                                countMap.put("jzmj", "0");
                                countMap.put("qllx", "0");
                                countMap.put("qlrlx", "0");
                                countMap.put("qlrmc", "0");
                                countMap.put("qxdm", "0");
                                countMap.put("slsj", "0");
                                countMap.put("syqmj", "0");
                                countMap.put("yt", "0");
                                countMap.put("ywh", "0");
                                countMap.put("zjh", "0");
                                countMap.put("fdcjyjg", "0");
                                countMap.put("bdbzzqse", "0");
                            }
                            countMap.put("sjgxsj", addDate);
                            baKxtjMapper.insertKxtj(countMap);
                        }
                    }
                } catch (Exception e) {
                    LOGGER.error("空项率统计定时任务执行异常！{}", e);
                    flag = true;
                }
                LOGGER.info("空项率统计定时任务执行完成");
                flag = true;
            }
        }

    }


}
