package cn.gtmap.realestate.supervise.server.quartz.kxltj;

import cn.gtmap.estateplat.core.ex.AppException;
import com.gtis.config.AppConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.expression.ParseException;
import org.springframework.scheduling.quartz.CronTriggerFactoryBean;
import org.springframework.scheduling.quartz.MethodInvokingJobDetailFactoryBean;

/**
 * @author <a href="mailto:gaofeng@gtmap.cn">gaofeng</a>
 * @version 1.0，2019/1/10
 * @description 空项统计
 */
@Configuration
public class KxltjScheduledConfig {

    private static final Logger LOGGER = LoggerFactory.getLogger(KxltjScheduledConfig.class);

    //定时任务执行时间
    private String cronTime = AppConfig.getProperty("supersive.kxtj.cron.time");

    @Autowired
    KxltjScheduledTask kxltjScheduledTask;

    @Bean
    public MethodInvokingJobDetailFactoryBean kxtjServiceFactoryBean() {
        MethodInvokingJobDetailFactoryBean bean = new MethodInvokingJobDetailFactoryBean();
        bean.setTargetObject(kxltjScheduledTask);
        bean.setTargetMethod("handleKx");
        bean.setConcurrent(false);
        return bean;
    }

    @Bean
    public CronTriggerFactoryBean kxtjServiceCronTriggerBean() {
        CronTriggerFactoryBean tigger = new CronTriggerFactoryBean();
        tigger.setJobDetail(kxtjServiceFactoryBean().getObject());
        try {
            tigger.setCronExpression(cronTime);
        } catch (ParseException e) {
            LOGGER.error("KxltjScheduledConfig.kxtjServiceCronTriggerBean.ParseException in!{}", e);
            throw new AppException(e, 2009);
        }
        return tigger;
    }
}
