package cn.gtmap.realestate.supervise.server.quartz.jrrz;

import cn.gtmap.realestate.supervise.entity.XtRegion;
import cn.gtmap.realestate.supervise.server.dao.mapper.BaAccessLogMapper;
import cn.gtmap.realestate.supervise.server.entity.AccessInfo;
import cn.gtmap.realestate.supervise.server.entity.AccessLog;
import cn.gtmap.realestate.supervise.server.entity.AccessLogs;
import cn.gtmap.realestate.supervise.server.entity.RegisterInfo;
import cn.gtmap.realestate.supervise.server.service.impl.JrrzServiceImpl;
import cn.gtmap.realestate.supervise.server.utils.TimeUtils;
import cn.gtmap.realestate.supervise.server.utils.XmlUtil;
import com.google.common.collect.Lists;
import com.gtis.config.AppConfig;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:gaofeng@gtmap.cn">gaofeng</a>
 * @version 1.0, 2018/8/3
 * @description 登薄日志数据处理类
 */
@Component
public class JrrzScheduledTask {

    private static final Logger LOGGER = LoggerFactory.getLogger(JrrzScheduledTask.class);

    @Autowired
    JrrzServiceImpl jrrzService;

    @Autowired
    BaAccessLogMapper baAccessLogMapper;

    //需要合并数据的区县代码配置
    String areaCodes = AppConfig.getProperty("supersive.jrrz.area.code");

    public void sendXmlInfos() {

        if (StringUtils.isNotBlank(areaCodes)) {
            String[] tempAreaCode = areaCodes.split("\\|");
            for (String areaCode : tempAreaCode) {
                if (StringUtils.isNotBlank(areaCode)) {
                    try {
                        AccessLogs accessLogs = dataPrepare(areaCode);
                        if (null != accessLogs) {
                            String xml = XmlUtil.entityToXml(accessLogs);//实体类转换xml
                            LOGGER.info("地区编码:{},开始登薄日志定时报部任务:{}", areaCode, xml);
                            String res = jrrzService.send(xml, accessLogs);
                            LOGGER.info("地区编码:{},结束登薄日志定时报部任务,报部返回结果:{}", areaCode, res);
                        }
                    } catch (Exception e) {
                        LOGGER.error("报部登薄日志定时任务执行异常!{}", e);

                    }
                }
            }
        }

    }


    /**
     * 数据准备
     *
     * @param areaCode
     * @return
     */
    private AccessLogs dataPrepare(String areaCode) {
        List<AccessLog> accessLogList = Lists.newArrayList();
        AccessLog accessLog = null;
        AccessLogs accessLogs = null;

        //先通过areacode和sfbb为false 找到对应的accessDate  accessDate可能是多条
        //找到这个时间  分别去统计
        Map<String, String> paramMap = new HashMap<>();
        paramMap.put("areacode", areaCode);
        List<String> accessDates = baAccessLogMapper.getAccessDates(paramMap);
        if (CollectionUtils.isNotEmpty(accessDates)) {
            for (int i = 0; i < accessDates.size(); i++) {
                RegisterInfo registerInfo = baAccessLogMapper.getRegisterInfo(areaCode,accessDates.get(i));//区县登簿信息记录
                AccessInfo accessInfo = baAccessLogMapper.getAccessInfo(areaCode,accessDates.get(i));//接入上报信息记录
                String areaCodeStr = "";
                String accessDate = "";
                String remark = "";
                String registerInfoId = registerInfo.getId();
                String accessInfoId = accessInfo.getId();
                if (StringUtils.isNotBlank(registerInfoId) && StringUtils.isNotBlank(accessInfoId)) {
                    accessLog = new AccessLog();
                    accessLogs = new AccessLogs();
                    if (null != registerInfo) {
                        areaCodeStr = registerInfo.getAreacode();
                        accessDate = TimeUtils.dateToStr(registerInfo.getAccessdate(), "yyyyMMdd");
                        remark = registerInfo.getRemark();
                        registerInfo.setAccessdate(null);
                        registerInfo.setAreacode(null);
                        registerInfo.setAreaname(null);
                        registerInfo.setRemark(null);
                        registerInfo.setId(null);
                        accessLog.setRegisterInfo(registerInfo);
                    }
                    if (null != accessInfo) {
                        areaCodeStr = accessInfo.getAreacode();
                        accessDate = TimeUtils.dateToStr(accessInfo.getAccessdate(), "yyyyMMdd");
                        remark = accessInfo.getRemark();
                        accessInfo.setAccessdate(null);
                        accessInfo.setAreacode(null);
                        accessInfo.setAreaname(null);
                        accessInfo.setRemark(null);
                        accessInfo.setId(null);
                        accessLog.setAccessInfo(accessInfo);
                    }
                    XtRegion xtRegion = baAccessLogMapper.getRegionByCode(areaCodeStr);
                    accessLog.setAreaName(xtRegion.getQhmc());
                    if (StringUtils.isBlank(remark)) {
                        accessLog.setRemark("");
                    } else {
                        accessLog.setRemark(remark);
                    }
                    accessLog.setAccessDate(accessDate);
                    accessLog.setAreaCode(areaCodeStr);
                    accessLogList.add(accessLog);
                    accessLogs.setAccessLog(accessLogList);
                }
            }
            return  accessLogs;
        }
        return accessLogs;
    }
}
