package cn.gtmap.realestate.supervise.server.quartz.jrrz;

import cn.gtmap.estateplat.core.ex.AppException;
import com.gtis.config.AppConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.expression.ParseException;
import org.springframework.scheduling.quartz.CronTriggerFactoryBean;
import org.springframework.scheduling.quartz.MethodInvokingJobDetailFactoryBean;

/**
 * @author <a href="mailto:gaofeng@gtmap.cn">gaofeng</a>
 * @version 1.0, 2018/8/3
 * @description 登薄日志数据定时报部
 */
@Configuration
public class JrrzScheduledConfig {

    private static final Logger LOGGER = LoggerFactory.getLogger(JrrzScheduledConfig.class);

    //定时任务执行时间
    private String cronTime = AppConfig.getProperty("supersive.jrrz.cron.time");


    @Autowired
    JrrzScheduledTask jrrzScheduledTask;

    @Bean
    public MethodInvokingJobDetailFactoryBean jrrzServiceFactoryBean() {
        MethodInvokingJobDetailFactoryBean bean = new MethodInvokingJobDetailFactoryBean();
        bean.setTargetObject(jrrzScheduledTask);
        bean.setTargetMethod("sendXmlInfos");
        bean.setConcurrent(false);
        return bean;
    }

    @Bean
    public CronTriggerFactoryBean jrrzServiceCronTriggerBean() {
        CronTriggerFactoryBean tigger = new CronTriggerFactoryBean();
        tigger.setJobDetail(jrrzServiceFactoryBean().getObject());
        try {
            tigger.setCronExpression(cronTime);
        } catch (ParseException e) {
            LOGGER.error("JrrzScheduledConfig.jrrzServiceCronTriggerBean.ParseException in!{}",e);
            throw new AppException(e, 2009);
        }
        return tigger;
    }
}
