package cn.gtmap.realestate.supervise.server.quartz.failresp;

import cn.gtmap.realestate.supervise.model.MessageServer;
import cn.gtmap.realestate.supervise.model.Respond;
import cn.gtmap.realestate.supervise.server.common.impl.DataInsertDbService;
import cn.gtmap.realestate.supervise.server.config.Constant;
import cn.gtmap.realestate.supervise.server.dao.mapper.BaJrdMapper;
import cn.gtmap.realestate.supervise.server.dao.mapper.BaSftpMapper;
import cn.gtmap.realestate.supervise.server.entity.ClientInfo;
import cn.gtmap.realestate.supervise.server.es.SearchService;
import cn.gtmap.realestate.supervise.server.rabbitmq.SendMessage;
import cn.gtmap.realestate.supervise.server.rocketmq.ProducerMsg;
import cn.gtmap.realestate.supervise.server.sftp.SftpService;
import cn.gtmap.realestate.supervise.server.utils.TimeUtils;
import cn.gtmap.realestate.supervise.server.utils.XmlUtil;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.config.AppConfig;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.stereotype.Component;
import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.WebApplicationContext;

import java.util.Date;
import java.util.Map;

/**
 * @author <a href="mailto:gaofeng@gtmap.cn">gaofeng</a>
 * @version 1.0, 2017/2/13
 * @description 定时取失败响应报文配置
 */
@Component
@Configurable
public class RecieveFailRespScheduledTasks {

    private static final Logger LOGGER = LoggerFactory.getLogger(RecieveFailRespScheduledTasks.class);

    private static final String respFailPath = AppConfig.getProperty("supervise.resp.fail.path");

    @Autowired
    private BaJrdMapper baJrdMapper;

    //    @Autowired
    private SendMessage sendMessage;

    @Autowired
    private SftpService sftpService;

    private boolean cornFlag = true;


    private ProducerMsg producerMsg;

    @Autowired
    private SearchService searchService;

    @Autowired
    private DataInsertDbService dataInsertDbService;

    @Autowired
    private BaSftpMapper baSftpMapper;

    public void reciveFailRespFile() {
        if (StringUtils.isNotBlank(respFailPath)) {
            if (cornFlag) {
                cornFlag = false;
                try {
                    LOGGER.info("取上报失败响应报文开始");
                    String[] fileNames = sftpService.sftpReciveFileNames(respFailPath);
                    for (String fileName : fileNames) {
                        if (fileName.endsWith("xml")) {
                            LOGGER.info("取上报失败响应报文文件名称begin:{}", fileName);
                            boolean flag = false;
                            String areaCode = fileName.substring(3, 9);
                            ClientInfo clientInfo = baJrdMapper.getJrdxxByQhdm(areaCode);
                            if (null == clientInfo) {
                                clientInfo = baJrdMapper.getJrdxxByFdm(areaCode);
                                if (null != clientInfo) {
                                    LOGGER.info("定时任务发送到队列1--队列名称:" + clientInfo.getDlmc());
                                    flag = true;
                                }
                            } else {
                                LOGGER.info("定时任务发送到队列2----队列名称:" + clientInfo.getDlmc());
                                flag = true;
                            }
                            if (flag) {
                                String content = sftpService.sftpReciveFileContent(fileName, respFailPath);
                                if(StringUtils.isNotBlank(content)){
                                    String fileId = UUIDGenerator.generate18();
                                    insertBbsbxybwEs(fileName, content,fileId);//市级平台保存报部失败响应报文
                                    baSftpMapper.updateEjsbZt(fileName,fileId);
                                }
                                sendRespMessage(content, fileName, areaCode, clientInfo.getDlmc());
                            }
                        }
                    }
                    cornFlag = true;
                } catch (Exception e) {
                    LOGGER.info("取上报失败响应报文Exception!{}", e);
                    cornFlag = true;
                }
            }
            LOGGER.info("取上报失败响应报文文件名称end");
        }

    }


    /**
     * 向客户端发送上报失败消息
     *
     * @param content
     * @param fileName
     * @param areaCode
     * @param queueName
     */

    private void sendRespMessage(String content, String fileName, String areaCode, String queueName) {

        try {
            String bizmsgid = XmlUtil.getTextByXpath("/respond/BizMsgID", content);
            String additionalData = XmlUtil.getTextByXpath("/respond/AdditionalData", content);
            String additionalData2 = XmlUtil.getTextByXpath("/respond/AdditionalData2", content);
            String responseInfo = XmlUtil.getTextByXpath("/respond/ResponseInfo", content);
            String responseCode = XmlUtil.getTextByXpath("/respond/ResponseCode", content);
            Respond responseMessage = new Respond();
            responseMessage.setSuccessFlag("0");
            responseMessage.setCertID("");
            responseMessage.setBizMsgID(bizmsgid);
            responseMessage.setAdditionalData2(additionalData2);
            responseMessage.setAdditionalData(additionalData);
            responseMessage.setQRCode("");
            responseMessage.setResponseInfo(responseInfo);
            responseMessage.setResponseCode(responseCode);
            responseMessage.setServerName(queueName);
            responseMessage.setFileName(fileName);
            responseMessage.setAreaCode(areaCode);
            responseMessage.setSbsbbj("1");//上报失败标记
            MessageServer messageServer = new MessageServer();
            messageServer.setResponseMessage(responseMessage);
            messageServer.setServerQueue(queueName);
            boolean envFlag = dataInsertDbService.getEnv();
            if (envFlag) {
                if (null == producerMsg) {
                    WebApplicationContext wac = ContextLoader.getCurrentWebApplicationContext();
                    producerMsg = (ProducerMsg) wac.getBean(ProducerMsg.class);
                }
                producerMsg.sendMsg(JSON.toJSONString(messageServer), queueName,fileName);
            } else {
                if (null == sendMessage) {
                    WebApplicationContext wac = ContextLoader.getCurrentWebApplicationContext();
                    sendMessage = (SendMessage) wac.getBean(SendMessage.class);
                }
                sendMessage.sendDirectMsg(JSON.toJSONString(messageServer), queueName);
            }
        } catch (Exception e) {
            LOGGER.error("解析部返回响应报文信息异常!{},fileName:{}", e, fileName);
        }
    }


    /**
     * 插入报部响应报文
     *
     * @param fileName
     * @param respString
     */
    public void insertBbsbxybwEs(String fileName, String respString,String bbjgid) {
        try {
//            List<String> xybwIdList = searchService.getBwidByFileName(fileName, Constant.BBSBXYBWBJ);//响应报文ID
//            if (CollectionUtils.isNotEmpty(xybwIdList)) {
//                String xybwid = xybwIdList.get(0);
//                searchService.delData(Constant.BBSBREP_INDEXTYPE, xybwid);//删除es已存在响应报文
//            }
            Map<String, Object> jsonStr = Maps.newHashMap();
            jsonStr.put("fileName", fileName);
            jsonStr.put("message", respString);
            jsonStr.put("dataTime", TimeUtils.dateToStr(new Date(), "yyyy-MM-dd HH:mm:ss"));
            jsonStr.put("fileId", bbjgid);
            searchService.mainCreateIndex(jsonStr, Constant.BBSBXYBWBJ);
        } catch (Exception e) {
            LOGGER.error("保存报部失败响应报文，入Es异常!{},fileName:{}", e, fileName);
        }
    }


}

