package cn.gtmap.realestate.supervise.server.quartz.failresp;


import cn.gtmap.estateplat.core.ex.AppException;
import cn.gtmap.realestate.supervise.server.quartz.sftp.RecieveSftpRespScheduledTasks;
import com.gtis.config.AppConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.expression.ParseException;
import org.springframework.scheduling.quartz.CronTriggerFactoryBean;
import org.springframework.scheduling.quartz.MethodInvokingJobDetailFactoryBean;

/**
 * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
 * @version 1.0, 2017/2/13
 * @description 定时器配置
 */
@Configuration
@Import({RecieveSftpRespScheduledTasks.class})
public class RecieveFailRespSchedledConfig {

    private static final Logger LOGGER = LoggerFactory.getLogger(RecieveFailRespSchedledConfig.class);

    @Autowired
    RecieveFailRespScheduledTasks recieveFailRespScheduledTasks;

    private String cronTime = AppConfig.getProperty("supervise.resp.fail.cronTime");

    /**
     *
     * @return
     */
    @Bean
    public MethodInvokingJobDetailFactoryBean reviceRespFailFileFactoryBean() {
        MethodInvokingJobDetailFactoryBean bean = new MethodInvokingJobDetailFactoryBean();
        bean.setTargetObject(recieveFailRespScheduledTasks);
        bean.setTargetMethod("reciveFailRespFile");
        bean.setConcurrent(false);
        return bean;
    }

    /**
     *
     * @return
     */
    @Bean
    public CronTriggerFactoryBean reviceRespFailFileCronTriggerBean() {
        CronTriggerFactoryBean tigger = new CronTriggerFactoryBean();
        tigger.setJobDetail(reviceRespFailFileFactoryBean().getObject());
        try {
            tigger.setCronExpression(cronTime);//每5秒执行一次
        } catch (ParseException e) {
            LOGGER.error("RecieveFailRespSchedledConfig.reviceRespFailFileCronTriggerBean.ParseException in！{}",e);
            throw new AppException(e, 2009);
        }
        return tigger;
    }
}
