package cn.gtmap.realestate.supervise.server.model.base;

import cn.gtmap.realestate.supervise.model.graph.base.Line;
import cn.gtmap.realestate.supervise.model.graph.base.Point;
import cn.gtmap.realestate.supervise.rsa.RSASignature;
import com.alibaba.fastjson.JSONObject;

import java.util.ArrayList;
import java.util.List;

/**
 * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
 * @version 1.0, 2017/7/21
 * @description 面(线的集合)
 */
public class Area extends ArrayList<Line> {

    public static final String PRIVAT_KEY = "MIICdwIBADANBgkqhkiG9w0BAQEFAASCAmEwggJdAgEAAoGBANP1Ow58aqG/7dPF5T+M3CyQ6Vc8XfkZ9+bigaNTILZqOmUSJFn7nvHnBhe2qHUHe6WdJBjU8s78/DyLSODW7BCg7SLMaTfUKsiWgWkoBy97kl8bHRcErVx9+wakW+PMv+C9Fkce+oY4fUE7JJPwRw6sOe5PdjcW1hsZ14OUfoAZAgMBAAECgYEAt0IFEI5Dx5vg7cPhZOPODX4xMWqROWnZa7eVLHgYBX+tA2v/IAmssCv1mZUk6yJQJq3J4upjENGs6E/o7/UC3f3juJCIAj0xyJ49x8FoKfHob+VZkkZEBIt7mPyvo1Pl9vW6dE50SQGrEkIIVOZdlKeWKzMKhsyFZqKGNM5cAgECQQD6EeHoHnakfQicM7LHwho2QEtJO+CjKl3EhmDbE3qKGn/W/xVpaDB/EqTfSR45r48009s1bmFjxIslIjNT10lBAkEA2Pv6uPZenhC/cvQNzUZIhHdUJti086N8AAedMkW9sr1Bp3O3hspKvvNYtzwEfGvQWa42qVPLrIjmAmlxNn9o2QJAWFJ2kpAn4ULUBq9vxoP01BJzRMNkPNzaz22Sye2gSyS+4EWp31fQQSFpn/9oMIGkN8lX1BBPT3h8mLnynPsdwQJBALkanNTVN/pYBzqlgHCxmIOI2L0a+aMuwEW2OR/95spoMW4MhW/zerhTGEeYZ6tMvj0DJZZl6caSMsWz9eSr5GECQDq4SKdjEu21caizzRHqyTIlo3675w+iPPrWxx9sKbqfN3OhEPgA7DKdH7s19Smw3kszdu0hVVAR0RpznGAp0Y4=";

    public List<Line> getLines() {
        return this;
    }

    public void addLine(Line line) {
        this.add(line);
    }

    public void setLines(List<Line> lines) {
        this.addAll(lines);
    }

    public boolean isArea() {
        boolean flag = true;
        for(Line line : this) {
            Point beginPoint = line.getBeginPoint();
            Point endPoint = line.getEndPoint();
            if(beginPoint.getX() != endPoint.getX() || beginPoint.getY() != endPoint.getY()) {
                flag = false;
                break;
            }
        }
        return flag;
    }

    /**
     * 强制修复Area，如果发现不闭环强行处理
     */
    public void MustArea() {
        for(Line line : this) {
            Point beginPoint = line.getBeginPoint();
            Point endPoint = line.getEndPoint();
            if(beginPoint.getX() != endPoint.getX() || beginPoint.getY() != endPoint.getY()) {
                Point newEndPoint = new Point();
                newEndPoint.setX(beginPoint.getX());
                newEndPoint.setY(beginPoint.getY());
                line.add(newEndPoint);
            }
        }
    }

    @Override
    public String toString() {
        return RSASignature.getSignature(JSONObject.toJSONString(this), PRIVAT_KEY);
    }
}
