package cn.gtmap.realestate.supervise.server.model;

import com.alibaba.fastjson.JSON;

/**
 * @author <a href="mailto:Administrator@gtmap.cn">Administrator</a>
 * @version 1.0, 2017/8/3
 * @description
 */
public class RabbitmqQueueInfo {

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @description 队列名称
     */
    private String name;

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @description 空间名称
     */
    private String vhost;

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @description 是否持久化
     */
    private String durable;

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @description 节点名称
     */
    private String node;

    private MessageStatus message_stats;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVhost() {
        return vhost;
    }

    public void setVhost(String vhost) {
        this.vhost = vhost;
    }

    public String getDurable() {
        return durable;
    }

    public void setDurable(String durable) {
        this.durable = durable;
    }

    public String getNode() {
        return node;
    }

    public void setNode(String node) {
        this.node = node;
    }

    public void setMessage_stats(MessageStatus message_stats) {
        this.message_stats = message_stats;
    }

    public MessageStatus getMessage_stats() {
        return message_stats;
    }

    public class MessageStatus {

        /**
         * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
         * @description 发布数量
         */
        private Integer publish;

        /**
         * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
         * @description 确认消费数量
         */
        private Integer deliver_get;

        /**
         * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
         * @description 等待消费数量
         */
        private Integer disk_reads;

        public Integer getPublish() {
            return publish;
        }

        public void setPublish(Integer publish) {
            this.publish = publish;
        }

        public Integer getDeliver_get() {
            return deliver_get;
        }

        public void setDeliver_get(Integer deliver_get) {
            this.deliver_get = deliver_get;
        }

        public Integer getDisk_reads() {
            return disk_reads;
        }

        public void setDisk_reads(Integer disk_reads) {
            this.disk_reads = disk_reads;
        }
    }

    public static RabbitmqQueueInfo getRabbitmqQueueInfo(String changeInfo) {
        return JSON.parseObject(changeInfo, RabbitmqQueueInfo.class);
    }

    public static RabbitmqClientQueueInfo getRabbitmqClientQueueInfo(String changeInfo) {
        return JSON.parseObject(changeInfo, RabbitmqClientQueueInfo.class);
    }
}
