package cn.gtmap.realestate.supervise.server.model;

import com.alibaba.fastjson.JSON;

/**
 * @author <a href="mailto:Administrator@gtmap.cn">Administrator</a>
 * @version 1.0, 2017/8/16
 * @description 获取RabbtiMq概览数据
 */
public class RabbitMqOverView {

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @description 启动服务器节点名称
     */
    private String cluster_name;

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @description rabbitmq版本号
     */
    private String rabbitmq_version;

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @description 数据统计
     */
    private Contents object_totals;

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @description 当前节点名称
     */
    private String node;

    public String getCluster_name() {
        return cluster_name;
    }

    public void setCluster_name(String cluster_name) {
        this.cluster_name = cluster_name;
    }

    public String getRabbitmq_version() {
        return rabbitmq_version;
    }

    public void setRabbitmq_version(String rabbitmq_version) {
        this.rabbitmq_version = rabbitmq_version;
    }

    public Contents getObject_totals() {
        return object_totals;
    }

    public void setObject_totals(Contents object_totals) {
        this.object_totals = object_totals;
    }

    public String getNode() {
        return node;
    }

    public void setNode(String node) {
        this.node = node;
    }

    public class Contents {

        /**
         * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
         * @description 该节点集群节点数
         */
        private Integer consumers;

        /**
         * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
         * @description 队列数量
         */
        private Integer queues;

        /**
         * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
         * @description 交换器数量
         */
        private Integer exchanges;

        /**
         * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
         * @description 链接数量
         */
        private Integer connections;

        /**
         * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
         * @description 信道数量
         */
        private Integer channels;

        public Integer getConsumers() {
            return consumers;
        }

        public void setConsumers(Integer consumers) {
            this.consumers = consumers;
        }

        public Integer getQueues() {
            return queues;
        }

        public void setQueues(Integer queues) {
            this.queues = queues;
        }

        public Integer getExchanges() {
            return exchanges;
        }

        public void setExchanges(Integer exchanges) {
            this.exchanges = exchanges;
        }

        public Integer getConnections() {
            return connections;
        }

        public void setConnections(Integer connections) {
            this.connections = connections;
        }

        public Integer getChannels() {
            return channels;
        }

        public void setChannels(Integer channels) {
            this.channels = channels;
        }
    }

    public static RabbitMqOverView getRabbitMqOverView(String changeInfo) {
        return JSON.parseObject(changeInfo, RabbitMqOverView.class);
    }
}
