package cn.gtmap.realestate.supervise.server.model;

import com.alibaba.fastjson.JSON;

/**
 * @author <a href="mailto:Administrator@gtmap.cn">Administrator</a>
 * @version 1.0, 2017/8/16
 * @description
 */
public class RabbitMqNodeInfo {

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @description 最低空余磁盘容量
     */
    private Long disk_free_limit;

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @description 磁盘空余容量
     */
    private Long disk_free;

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @description 内存限制字节
     */
    private Long mem_limit;

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @description 内存使用
     */
    private Long mem_used;


    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @description 已使用连接数
     */
    private Long proc_used;

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @description 最大连接数
     */
    private Long proc_total;

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @description 对话总数
     */
    private Long sockets_total;

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @description 已使用对话数
     */
    private Long sockets_used;

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @description 总共文件数
     */
    private Long fd_total;

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @description 已存放文件数
     */
    private Long fd_used;


    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @description 跟新时间
     */
    private Long uptime;


    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @description 节点类型 磁盘或内存
     */
    private String type;

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @description 是否在运行
     */
    private boolean running;

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @description 节点名称
     */
    private String name;

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @param changeInfo 需要转换的json数据
     * @return 返回转换后对象
     * @description 根据Json数据返回特定内容的对象
     */
    public static RabbitMqNodeInfo getRabbitMqNodeInfo(String changeInfo) {
        return JSON.parseObject(changeInfo, RabbitMqNodeInfo.class);
    }

    public Long getDisk_free_limit() {
        return disk_free_limit;
    }

    public void setDisk_free_limit(Long disk_free_limit) {
        this.disk_free_limit = disk_free_limit;
    }

    public Long getMem_limit() {
        return mem_limit;
    }

    public void setMem_limit(Long mem_limit) {
        this.mem_limit = mem_limit;
    }

    public Long getUptime() {
        return uptime;
    }

    public void setUptime(Long uptime) {
        this.uptime = uptime;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isRunning() {
        return running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getDisk_free() {
        return disk_free;
    }

    public void setDisk_free(Long disk_free) {
        this.disk_free = disk_free;
    }

    public Long getMem_used() {
        return mem_used;
    }

    public void setMem_used(Long mem_used) {
        this.mem_used = mem_used;
    }

    public Long getProc_used() {
        return proc_used;
    }

    public void setProc_used(Long proc_used) {
        this.proc_used = proc_used;
    }

    public Long getProc_total() {
        return proc_total;
    }

    public void setProc_total(Long proc_total) {
        this.proc_total = proc_total;
    }

    public Long getSockets_total() {
        return sockets_total;
    }

    public void setSockets_total(Long sockets_total) {
        this.sockets_total = sockets_total;
    }

    public Long getSockets_used() {
        return sockets_used;
    }

    public void setSockets_used(Long sockets_used) {
        this.sockets_used = sockets_used;
    }

    public Long getFd_total() {
        return fd_total;
    }

    public void setFd_total(Long fd_total) {
        this.fd_total = fd_total;
    }

    public Long getFd_used() {
        return fd_used;
    }

    public void setFd_used(Long fd_used) {
        this.fd_used = fd_used;
    }
}
