package cn.gtmap.realestate.supervise.server.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.apache.commons.collections.CollectionUtils;

import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:gaofeng@gtmap.cn">gaofeng</a>
 * @version 1.0, 2018/7/8
 * @description 定时上图信息
 */
public class GraphicData {

    //宗海不动产单元信息
    private static List<String> zhList = Lists.newArrayList();

    //宗地不动产单元信息
    private static List<String> zdList = Lists.newArrayList();

    //宗海上图信息
    private static List<Map<String,String>> zhzbList  = Lists.newArrayList();

    //宗地上图信息
    private static List<Map<String,String>> zdzbList = Lists.newArrayList();


    //添加宗海上图不动产单元号
    public static void addZhAllList(List<String> bdcdys){
        zhList.addAll(bdcdys);
    }

    //根据宗海不动产单元删除单元号
    public static void removeZhList(){
        if(CollectionUtils.isNotEmpty(zhList)){
            zhList.remove(0);
        }
    }

    public static List<String> getZhList(){
        return zhList;
    }

    public static List<String> getZdList(){
        return zdList;
    }

    //添加宗地上图不动产单元号
    public static void addZdAllList(List<String> bdcdys){
        zdList.addAll(bdcdys);
    }

    //根据宗地不动产单元删除单元号
    public static void removeZdList(){
        if(CollectionUtils.isNotEmpty(zdList)){
            zdList.remove(0);
        }
    }

    //根据不动产单元号获取上图坐标信息
    public static Map<String,String> getZhGraphic(){
        if(CollectionUtils.isNotEmpty(zhzbList)){
            Map<String,String> zhData = zhzbList.get(0);
            zhzbList.remove(zhData);
            return zhData;
        }
       return Maps.newHashMap();
    }

    //添加上图信息
    public static  void putZhGraphic(Map<String,String> data){
        zhzbList.add(data);
    };

    //根据不动产单元号获取上图坐标信息
    public  static Map<String,String> getZdGraphic(){
        if(CollectionUtils.isNotEmpty(zdzbList)){
            Map<String,String> zdData = zdzbList.get(0);
            zdzbList.remove(zdData);
            return zdData;
        }
        return Maps.newHashMap();
    }

    //添加上图信息
    public static  void putZdGraphic(Map<String,String> data){
        zdzbList.add(data);
    };

    public static  List<Map<String,String>> getZdzbList(){
        return zdzbList;
    }

    public static  List<Map<String,String>> getZhzbList(){
        return  zhzbList;
    }

}
