package cn.gtmap.realestate.supervise.server.model;

import cn.gtmap.realestate.supervise.model.FileMessage;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;


/**
 * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
 * @version 1.0, 2017/4/18
 * @description xml检查结果模型
 */
public class CheckResult implements Serializable{

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @description 封装文件对象
     */
    private FileMessage fileMessage;

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @description 文件验证错误集合
     */
    private List<String> errors = new ArrayList<String>();

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @description 添加错误
     */
    public void addError(String errorInfo) {
        errors.add(errorInfo);
    }


    public List<String> getErrors() {
        return errors;
    }

    public void setErrors(List<String> errors) {
        this.errors = errors;
    }



    public FileMessage getFileMessage() {
        return fileMessage;
    }

    public void setFileMessage(FileMessage fileMessage) {
        this.fileMessage = fileMessage;
    }

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @param
     * @return 错误日志字符串
     * @description 重写了object的toString方法用于拼接输出错误日志
     */
    @Override
    public String toString() {
        StringBuilder str = new StringBuilder("验证xml报文出现问题如下：");
        if(errors.size() > 0) {
            for(String error : errors) {
                str.append(" " + error);
            }
        }
        return str.toString();
    }
}
