package cn.gtmap.realestate.supervise.server.model;

import cn.gtmap.realestate.supervise.model.FileMessage;
import cn.gtmap.realestate.supervise.server.entity.Rzjl;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.apache.commons.collections.CollectionUtils;

import java.util.List;
import java.util.Map;

/**
 * Created by Administrator on 2018/7/3.
 * 报文重新入库临时data
 */
public class BwcxrkData {

    //存放每个区县要删除数据
    static Map<String, List<FileMessage>> delDataMap = Maps.newHashMap();

    //存放每个区县要入库数据
    static Map<String, List<FileMessage>> allDataMap = Maps.newHashMap();

    //临时变量
    static Map<String, List<FileMessage>> delTempMap = Maps.newHashMap();

    //存放每个区县所有数据
    static Map<String, List<Rzjl>> checkDataMap = Maps.newHashMap();

    //异常数据
    static Map<String, List<FileMessage>> exceptionDataMap = Maps.newHashMap();

    public static FileMessage getDelData(String qhdm) {
        if (delDataMap.containsKey(qhdm) && CollectionUtils.isNotEmpty(delDataMap.get(qhdm))) {
            List<FileMessage> fileMessages = delDataMap.get(qhdm);
            FileMessage fileMessage = fileMessages.get(0);
            fileMessages.remove(fileMessage);
            return fileMessage;
        }
        return null;
    }

    public static void setDelData(String qhdm, FileMessage fileMessage) {
        if (delDataMap.containsKey(qhdm)) {
            List<FileMessage> fileMessages = delDataMap.get(qhdm);
            fileMessages.add(fileMessage);
        } else {
            List<FileMessage> fileMessages = Lists.newArrayList();
            fileMessages.add(fileMessage);
            delDataMap.put(qhdm, fileMessages);
        }
    }

    public static FileMessage getAllDataOne(String qhdm) {
        if (allDataMap.containsKey(qhdm) && CollectionUtils.isNotEmpty(allDataMap.get(qhdm))) {
            List<FileMessage> fileMessages = allDataMap.get(qhdm);
            FileMessage fileMessage = fileMessages.get(0);
            fileMessages.remove(fileMessage);
            return fileMessage;
        }
        return null;
    }

    public static void setAllDataList(String qhdm, FileMessage fileMessage) {
        if (allDataMap.containsKey(qhdm)) {
            List<FileMessage> fileMessages = allDataMap.get(qhdm);
            fileMessages.add(fileMessage);
        } else {
            List<FileMessage> fileMessages = Lists.newArrayList();
            fileMessages.add(fileMessage);
            allDataMap.put(qhdm, fileMessages);
        }
    }


    /**
     * 根据qhdm获取对应所有数据
     *
     * @param qhdm
     * @return
     */
    public static List<FileMessage> getAllDataList(String qhdm) {
        if (allDataMap.containsKey(qhdm)) {
            List<FileMessage> fileMessages = allDataMap.get(qhdm);
            return fileMessages;
        }
        return Lists.newArrayList();
    }

    public static List<Rzjl> getCheckDataList(String qhdm) {
        if (checkDataMap.containsKey(qhdm)) {
            return checkDataMap.get(qhdm);
        }
        return Lists.newArrayList();
    }

    public static void setCheckDataList(String qhdm, List<Rzjl> checkData) {
        checkDataMap.put(qhdm, checkData);
    }

    public static void removeRzjl(String qhdm) {
        if (checkDataMap.containsKey(qhdm) && CollectionUtils.isNotEmpty(checkDataMap.get(qhdm))) {
            List<Rzjl> rzjlList = checkDataMap.get(qhdm);
            rzjlList.remove(0);
        }
    }

    /**
     * 获取要删除所有数据
     *
     * @param qhdm
     * @return
     */
    public static List<FileMessage> getDelDataList(String qhdm) {
        if (delDataMap.containsKey(qhdm)) {
            List<FileMessage> fileMessages = delDataMap.get(qhdm);
            return fileMessages;
        }
        return Lists.newArrayList();
    }


    public static void setDelTempMap(String qhdm, FileMessage fileMessage) {
        if (delTempMap.containsKey(qhdm)) {
            List<FileMessage> fileMessages = delTempMap.get(qhdm);
            fileMessages.add(fileMessage);
        } else {
            List<FileMessage> fileMessages = Lists.newArrayList();
            fileMessages.add(fileMessage);
            delTempMap.put(qhdm, fileMessages);
        }
    }


    public static List<FileMessage> getDelTempDataList(String qhdm) {
        if (delTempMap.containsKey(qhdm)) {
            List<FileMessage> fileMessages = delTempMap.get(qhdm);
            return fileMessages;
        }
        return Lists.newArrayList();
    }

    public static void removeTempData(String qhdm) {
        if (delTempMap.containsKey(qhdm) && CollectionUtils.isNotEmpty(delTempMap.get(qhdm))) {
            List<FileMessage> fileMessages = delTempMap.get(qhdm);
            fileMessages.remove(0);
        }
    }

    public static List<FileMessage> getExceptionDataList(String qhdm) {
        if (exceptionDataMap.containsKey(qhdm)) {
            List<FileMessage> fileMessages = exceptionDataMap.get(qhdm);
            return fileMessages;
        }
        return Lists.newArrayList();
    }


    public static void setExceptionDataMap(String qhdm, FileMessage fileMessage) {
        if (exceptionDataMap.containsKey(qhdm)) {
            List<FileMessage> fileMessages = exceptionDataMap.get(qhdm);
            fileMessages.add(fileMessage);
        } else {
            List<FileMessage> fileMessages = Lists.newArrayList();
            fileMessages.add(fileMessage);
            exceptionDataMap.put(qhdm, fileMessages);
        }
    }

    public static void removeAllExceptionDataMap(String qhdm) {
        if (exceptionDataMap.containsKey(qhdm) && CollectionUtils.isNotEmpty(exceptionDataMap.get(qhdm))) {
            exceptionDataMap.remove(qhdm);
        }
    }


    public static void removeAllDelDataMap(String qhdm) {
        if (delDataMap.containsKey(qhdm) && CollectionUtils.isNotEmpty(delDataMap.get(qhdm))) {
            delDataMap.remove(qhdm);
        }
    }

    public static void removeAllDataMap(String qhdm) {
        if (allDataMap.containsKey(qhdm) && CollectionUtils.isNotEmpty(allDataMap.get(qhdm))) {
            allDataMap.remove(qhdm);
        }
    }

    public static void removeAllcheckDataMap(String qhdm) {
        if (checkDataMap.containsKey(qhdm) && CollectionUtils.isNotEmpty(checkDataMap.get(qhdm))) {
            checkDataMap.remove(qhdm);
        }
    }
}
