package cn.gtmap.realestate.supervise.server.es;

import com.google.common.collect.Lists;
import com.gtis.config.AppConfig;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequestBuilder;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;

@Component
public class SearchService {

    private static final Logger LOGGER = LoggerFactory.getLogger(SearchService.class);

    // 创建私有对象
    private static TransportClient client;

    //数据库名字
    private String indexName = "serverdata";

    //表名
    private String indexTypeBiz = "Biz";//业务报文

    private String indexTypeRep = "Rep";//上级响应报文

    private String indexTypeBrep = "Brep";//部响应报文

    private String indexTypeBbsbrep = "Bbsbrep";//报部失败

    private String bbxybw = "1";//报部响应报文

    private String bbsbxy = "2";//报部失败响应报文

    private static String ipStr = AppConfig.getProperty("supervise.es.ip");

    static {
        try {
            Settings settings = Settings.settingsBuilder()
                    .put("client.transport.sniff", true)
                    .put("client.transport.ignore_cluster_name", true)
                    .build();
            client = TransportClient.builder().settings(settings).build()
                    .addTransportAddress(new InetSocketTransportAddress(InetAddress.getByName(ipStr), 9300));
        } catch (UnknownHostException e) {
            LOGGER.error("------------SearchService.UnknownHostException in!{}", e);
        }
    }

    /**
     * 创建索引、数据入库
     *
     * @param json
     */
    public void mainCreateIndex(Map<String, Object> json, String flag) {
        IndexRequest indexRequest = new IndexRequest();
        String fileName = String.valueOf(json.get("fileName"));

        //业务报文
        if (fileName.startsWith(indexTypeBiz) && StringUtils.isBlank(flag)) {
            indexRequest = client.prepareIndex(indexName, indexTypeBiz).setSource(json).request();
        }

        //报省响应报文
        if (fileName.startsWith(indexTypeRep) && StringUtils.isBlank(flag)) {
            indexRequest = client.prepareIndex(indexName, indexTypeRep).setSource(json).request();
        }

        //报部响应报文
        if (fileName.startsWith(indexTypeRep) && StringUtils.equals(flag, bbxybw)) {
            indexRequest = client.prepareIndex(indexName, indexTypeBrep).setSource(json).request();
        }

        //报部失败响应报文
        if (fileName.startsWith(indexTypeRep) && StringUtils.equals(flag, bbsbxy)) {
            indexRequest = client.prepareIndex(indexName, indexTypeBbsbrep).setSource(json).request();
        }
        BulkRequestBuilder bulkRequest = client.prepareBulk();
        bulkRequest.add(indexRequest);
        BulkResponse bulkresponse = bulkRequest.execute().actionGet();
        if (bulkresponse.hasFailures()) {
            LOGGER.info("创建索引出错");
        }
    }


    /**
     * 查看报文信息
     *
     * @param fileName
     * @param respCode
     * @return
     */
    public String mainGetData(String fileName, String respCode, String flag, String ywbwid, String xybwid) {


        //创建查询规则
        SearchRequestBuilder srb = null;
        if (fileName.startsWith(indexTypeBiz) && StringUtils.isBlank(flag) && StringUtils.isBlank(ywbwid)) {
            srb = client.prepareSearch(indexName).setTypes(indexTypeBiz);
            QueryBuilder qb2 = QueryBuilders.matchPhraseQuery("fileName", fileName);
            srb.setQuery(qb2);
        }
        if (fileName.startsWith(indexTypeBiz) && StringUtils.isBlank(flag) && StringUtils.isNotBlank(ywbwid)) {
            srb = client.prepareSearch(indexName).setTypes(indexTypeBiz);
            MatchQueryBuilder matchQueryBuilder1 = QueryBuilders.matchPhraseQuery("fileName", fileName);
            MatchQueryBuilder matchQueryBuilder2 = QueryBuilders.matchPhraseQuery("fileId", ywbwid);
            QueryBuilder qb2 = QueryBuilders.boolQuery().must(matchQueryBuilder1).must(matchQueryBuilder2);
            srb.setQuery(qb2);
        }
        if (fileName.startsWith(indexTypeRep) && StringUtils.isBlank(flag) && StringUtils.isBlank(xybwid)) {
            srb = client.prepareSearch(indexName).setTypes(indexTypeRep);
            MatchQueryBuilder matchQueryBuilder1 = QueryBuilders.matchPhraseQuery("fileName", fileName);
            MatchQueryBuilder matchQueryBuilder2 = QueryBuilders.matchPhraseQuery("respCode", respCode);
            QueryBuilder qb2 = QueryBuilders.boolQuery().must(matchQueryBuilder1).must(matchQueryBuilder2);
            srb.setQuery(qb2);
        }
        if (fileName.startsWith(indexTypeRep) && StringUtils.isBlank(flag) && StringUtils.isNotBlank(xybwid)) {
            srb = client.prepareSearch(indexName).setTypes(indexTypeRep);
            MatchQueryBuilder matchQueryBuilder1 = QueryBuilders.matchPhraseQuery("fileName", fileName);
            MatchQueryBuilder matchQueryBuilder2 = QueryBuilders.matchPhraseQuery("respCode", respCode);
            MatchQueryBuilder matchQueryBuilder3 = QueryBuilders.matchPhraseQuery("fileId", xybwid);
            QueryBuilder qb2 = QueryBuilders.boolQuery().must(matchQueryBuilder1).must(matchQueryBuilder2).must(matchQueryBuilder3);
            srb.setQuery(qb2);
        }

        if (fileName.startsWith(indexTypeRep) && StringUtils.equals(flag, bbxybw) &&
                StringUtils.isNotBlank(respCode) && StringUtils.isBlank(xybwid)) {
            srb = client.prepareSearch(indexName).setTypes(indexTypeBrep);
            MatchQueryBuilder matchQueryBuilder1 = QueryBuilders.matchPhraseQuery("fileName", fileName);
            MatchQueryBuilder matchQueryBuilder2 = QueryBuilders.matchPhraseQuery("respCode", respCode);
            QueryBuilder qb2 = QueryBuilders.boolQuery().must(matchQueryBuilder1).must(matchQueryBuilder2);
            srb.setQuery(qb2);
        }
        if (fileName.startsWith(indexTypeRep) && StringUtils.equals(flag, bbxybw) &&
                StringUtils.isNotBlank(respCode) && StringUtils.isNotBlank(xybwid)) {
            srb = client.prepareSearch(indexName).setTypes(indexTypeBrep);
            MatchQueryBuilder matchQueryBuilder1 = QueryBuilders.matchPhraseQuery("fileName", fileName);
            MatchQueryBuilder matchQueryBuilder2 = QueryBuilders.matchPhraseQuery("respCode", respCode);
            MatchQueryBuilder matchQueryBuilder3 = QueryBuilders.matchPhraseQuery("fileId", xybwid);
            QueryBuilder qb2 = QueryBuilders.boolQuery().must(matchQueryBuilder1).must(matchQueryBuilder2).must(matchQueryBuilder3);
            srb.setQuery(qb2);
        }
        if (fileName.startsWith(indexTypeRep) && StringUtils.equals(flag, bbxybw) && StringUtils.isBlank(respCode)) {
            srb = client.prepareSearch(indexName).setTypes(indexTypeBrep);
            MatchQueryBuilder matchQueryBuilder1 = QueryBuilders.matchPhraseQuery("fileName", fileName);
            QueryBuilder qb2 = QueryBuilders.boolQuery().must(matchQueryBuilder1);
            srb.setQuery(qb2);
        }
        if (fileName.startsWith(indexTypeRep) && StringUtils.equals(flag, bbxybw)
                && StringUtils.isBlank(respCode) && StringUtils.isNotBlank(xybwid)) {
            srb = client.prepareSearch(indexName).setTypes(indexTypeBrep);
            MatchQueryBuilder matchQueryBuilder1 = QueryBuilders.matchPhraseQuery("fileName", fileName);
            MatchQueryBuilder matchQueryBuilder2 = QueryBuilders.matchPhraseQuery("fileId", xybwid);
            QueryBuilder qb2 = QueryBuilders.boolQuery().must(matchQueryBuilder1).must(matchQueryBuilder2);
            srb.setQuery(qb2);
        }
        if (fileName.startsWith(indexTypeRep) && StringUtils.equals(flag, bbsbxy)
                && StringUtils.isBlank(respCode) && StringUtils.isBlank(xybwid)) {
            srb = client.prepareSearch(indexName).setTypes(indexTypeBbsbrep);
            MatchQueryBuilder matchQueryBuilder1 = QueryBuilders.matchPhraseQuery("fileName", fileName);
            QueryBuilder qb2 = QueryBuilders.boolQuery().must(matchQueryBuilder1);
            srb.setQuery(qb2);
        }
        if (fileName.startsWith(indexTypeRep) && StringUtils.equals(flag, bbsbxy)
                && StringUtils.isBlank(respCode) && StringUtils.isNotBlank(xybwid)) {
            srb = client.prepareSearch(indexName).setTypes(indexTypeBbsbrep);
            MatchQueryBuilder matchQueryBuilder1 = QueryBuilders.matchPhraseQuery("fileName", fileName);
            MatchQueryBuilder matchQueryBuilder2 = QueryBuilders.matchPhraseQuery("fileId", xybwid);
            QueryBuilder qb2 = QueryBuilders.boolQuery().must(matchQueryBuilder1).must(matchQueryBuilder2);
            srb.setQuery(qb2);
        }
        String resStr = "";
        //开始搜索
        if (null != srb) {
            SearchResponse searchResponse = srb.execute().actionGet();

            //获取高亮
            SearchHits searchHits = searchResponse.getHits();
            SearchHit[] hits = searchHits.getHits();
            if (null != hits && hits.length > 0) {
                Map<String, Object> source = hits[0].getSource();
                resStr = String.valueOf(source.get("message"));
            }
        }
        return resStr;
    }

    /**
     * 批量删除Es数据
     */
    public void recreateIndex() {
        LOGGER.debug("-----------删除ES数据开始！------");
        //删除索引
        client.admin().indices().prepareDelete(indexName).execute().actionGet();
        LOGGER.debug("-----------删除ES数据成功！------");
    }

    /**
     * 根据条件删除Es数据
     */
    public void delData(String indexType, String id) {
        LOGGER.info("-----------删除ES一条数据开始！------");
        DeleteRequestBuilder drBuilder = client.prepareDelete(indexName, indexType, id);
        //删除索引
        DeleteResponse response = drBuilder.execute().actionGet();
        if (response.isFound()) {
            LOGGER.info("-----------删除ES一条数据成功！------");
        } else {
            LOGGER.info("-----------删除ES一条数据失败！------");
        }
    }


    /**
     * 查看报文信息
     *
     * @param fileName
     * @return
     */
    public List<String> getBwidByFileName(String fileName, String flag,String ywbwid) {

        //创建查询规则
        SearchRequestBuilder srb = null;
        if (fileName.startsWith(indexTypeBiz) && StringUtils.isBlank(flag) && StringUtils.isBlank(ywbwid)) {
            srb = client.prepareSearch(indexName).setTypes(indexTypeBiz);
            QueryBuilder qb2 = QueryBuilders.matchPhraseQuery("fileName", fileName);
            srb.setQuery(qb2);
        }
        if (fileName.startsWith(indexTypeBiz) && StringUtils.isBlank(flag) && StringUtils.isNotBlank(ywbwid)) {
            srb = client.prepareSearch(indexName).setTypes(indexTypeBiz);
            QueryBuilder qb1 = QueryBuilders.matchPhraseQuery("fileName", fileName);
            QueryBuilder qb2 = QueryBuilders.matchPhraseQuery("fileId", ywbwid);
            QueryBuilder qb = QueryBuilders.boolQuery().must(qb1).must(qb2);
            srb.setQuery(qb);
        }
        if (fileName.startsWith(indexTypeRep) && StringUtils.isBlank(flag)) {
            srb = client.prepareSearch(indexName).setTypes(indexTypeRep);
            QueryBuilder qb2 = QueryBuilders.matchPhraseQuery("fileName", fileName);
            srb.setQuery(qb2);
        }
        if (fileName.startsWith(indexTypeRep) && StringUtils.equals(flag, bbxybw)) {
            srb = client.prepareSearch(indexName).setTypes(indexTypeBrep);
            QueryBuilder qb2 = QueryBuilders.matchPhraseQuery("fileName", fileName);
            srb.setQuery(qb2);
        }

        if (fileName.startsWith(indexTypeRep) && StringUtils.equals(flag, bbsbxy)) {
            srb = client.prepareSearch(indexName).setTypes(indexTypeBbsbrep);
            QueryBuilder qb2 = QueryBuilders.matchPhraseQuery("fileName", fileName);
            srb.setQuery(qb2);
        }

        //开始搜索
        List<String> resList = Lists.newArrayList();
        if (null != srb) {
            SearchResponse searchResponse = srb.execute().actionGet();
            //获取高亮
            SearchHits searchHits = searchResponse.getHits();
            SearchHit[] hits = searchHits.getHits();
            for (SearchHit searchhit : hits) {
                //获取高亮记录
                String id = searchhit.getId();
                resList.add(id);
            }
        }
        return resList;
    }

    public void mainCreateIndex(Map<String, Object> json) {
        IndexRequest indexRequest = new IndexRequest();
        String fileName = String.valueOf(json.get("fileName"));
        if (fileName.startsWith(this.indexTypeBiz)) {
            indexRequest = (IndexRequest) client.prepareIndex(this.indexName, this.indexTypeBiz).setSource(json).request();
        }
        if (fileName.startsWith(this.indexTypeRep)) {
            indexRequest = (IndexRequest) client.prepareIndex(this.indexName, this.indexTypeRep).setSource(json).request();
        }

        BulkRequestBuilder bulkRequest = client.prepareBulk();
        bulkRequest.add(indexRequest);
        BulkResponse bulkresponse = (BulkResponse) bulkRequest.execute().actionGet();
        if (bulkresponse.hasFailures())
            LOGGER.info("创建索引出错");
    }

    public String mainGetData(String fileName, String respCode) {
        SearchRequestBuilder srb = null;
        if (fileName.startsWith(this.indexTypeBiz)) {
            srb = client.prepareSearch(new String[]{this.indexName}).setTypes(new String[]{this.indexTypeBiz});
            QueryBuilder qb2 = QueryBuilders.matchPhraseQuery("fileName", fileName);
            srb.setQuery(qb2);
        }
        if (fileName.startsWith(this.indexTypeRep)) {
            srb = client.prepareSearch(new String[]{this.indexName}).setTypes(new String[]{this.indexTypeRep});
            MatchQueryBuilder matchQueryBuilder1 = QueryBuilders.matchPhraseQuery("fileName", fileName);
            MatchQueryBuilder matchQueryBuilder2 = QueryBuilders.matchPhraseQuery("respCode", respCode);
            QueryBuilder qb2 = QueryBuilders.boolQuery().must(matchQueryBuilder1).must(matchQueryBuilder2);
            srb.setQuery(qb2);
        }
        String resStr = "";

        if (null != srb) {
            SearchResponse searchResponse = (SearchResponse) srb.execute().actionGet();

            SearchHits searchHits = searchResponse.getHits();
            SearchHit[] hits = searchHits.getHits();
            for (SearchHit searchhit : hits) {
                Map source = searchhit.getSource();
                resStr = String.valueOf(source.get("message"));
            }
        }

        return resStr;
    }


    public List<String> getBwidByFileName(String fileName) {
        SearchRequestBuilder srb = null;
        if (fileName.startsWith(this.indexTypeBiz)) {
            srb = client.prepareSearch(new String[]{this.indexName}).setTypes(new String[]{this.indexTypeBiz});
            QueryBuilder qb2 = QueryBuilders.matchPhraseQuery("fileName", fileName);
            srb.setQuery(qb2);
        }
        if (fileName.startsWith(this.indexTypeRep)) {
            srb = client.prepareSearch(new String[]{this.indexName}).setTypes(new String[]{this.indexTypeRep});
            QueryBuilder qb2 = QueryBuilders.matchPhraseQuery("fileName", fileName);
            srb.setQuery(qb2);
        }

        List resList = Lists.newArrayList();
        if (null != srb) {
            SearchResponse searchResponse = (SearchResponse) srb.execute().actionGet();

            SearchHits searchHits = searchResponse.getHits();
            SearchHit[] hits = searchHits.getHits();
            for (SearchHit searchhit : hits) {
                String id = searchhit.getId();
                resList.add(id);
            }
        }
        return resList;
    }

}
