package cn.gtmap.realestate.supervise.server.entity;

import java.io.Serializable;

/**
 * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
 * @version 1.0, 2017/6/5
 * @description  sftp信息实体类
 */
public class SftpClientInfo implements Serializable{

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @description 用于标识我们需要上报的对象名称
     */
    private String sftpName;

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @description sftpId 用于标识我们需要上报的对象id
     */

    private String sftpId;

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @description sftp 用户名，sftp上传文件的必须的参数
     */

    private String userName;

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @description sftp 上传文件服务器ip sftp上传文件必须参数
     */

    private String ip;


    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @description sftp 上传文件需要的秘钥路径，是sftp通过秘钥上传文件的必须参数（如果是密码验证则不需要这个参数）
     * passWord和privateKey参数必须有一个不为空
     */

    private String privateKey;


    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @description sftp 上传文件需要知道sftp服务的端口号，sftp上传文件必须参数
     */

    private int port;


    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @description sftp 上传文件需要的密码，是sftp通过密码上传文件的必须参数（如果是秘钥验证则不需要这个参数）
     * passWord和privateKey参数必须有一个不为空
     */

    private String passWord;


    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @description 消息发送路径
     */

    private String messagePath;


    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @description 消息反应接路径
     */

    private String reciveMessagePath;


    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getPrivateKey() {
        return privateKey;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    public int getPort() {
        return port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getPassWord() {
        return passWord;
    }

    public void setPassWord(String passWord) {
        this.passWord = passWord;
    }

    public String getSftpId() {
        return sftpId;
    }

    public void setSftpId(String sftpId) {
        this.sftpId = sftpId;
    }

    public String getSftpName() {
        return sftpName;
    }

    public void setSftpName(String sftpName) {
        this.sftpName = sftpName;
    }

    public String getMessagePath() {
        return messagePath;
    }

    public void setMessagePath(String messagePath) {
        this.messagePath = messagePath;
    }

    public String getReciveMessagePath() {
        return reciveMessagePath;
    }

    public void setReciveMessagePath(String reciveMessagePath) {
        this.reciveMessagePath = reciveMessagePath;
    }
}
