package cn.gtmap.realestate.supervise.server.entity;

import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * @author <a href="mailto:gaofeng@gtmap.cn">gaofeng</a>
 * @version 1.0, 2017/4/11
 * @description 接入点管理实体类
 */
@Entity
@Table(name = "ba_jrd")
public class ClientInfo implements Serializable {

    /**
     * 客户端编码
     */
    @Id
    private String khdbm;

    /**
     * 客户端密码
     */
    private String khdmm;

    /**
     * 区县代码
     */
    private String qxdm;

    /**
     * 区县名称
     */
    private String qxmc;

    /**
     * 接入时间
     */
    private Date jrsj;

    /**
     * 负责人
     */
    private String fzr;

    /**
     * 备注
     */
    private String bz;

    /**
     * 前置机IP
     */
    private String ip;

    /**
     * 前置机端口号
     */
    private String port;

    //接入点队列名称
    private String dlmc;

    //接入点状态
    private String jrdzt;

    //状态更新时间
    private Date ztgxsj;

    public String getDlmc() {
        return dlmc;
    }

    public void setDlmc(String dlmc) {
        this.dlmc = dlmc;
    }

    public String getKhdbm() {
        return khdbm;
    }

    public String getQxdm() {
        return qxdm;
    }

    public String getQxmc() {
        return qxmc;
    }

    public Date getJrsj() {
        return jrsj;
    }

    public void setKhdbm(String khdbm) {
        this.khdbm = khdbm;
    }

    public void setQxdm(String qxdm) {
        this.qxdm = qxdm;
    }

    public void setQxmc(String qxmc) {
        this.qxmc = qxmc;
    }

    public void setJrsj(Date jrsj) {
        this.jrsj = jrsj;
    }

    public void setFzr(String fzr) {
        this.fzr = fzr;
    }

    public void setBz(String bz) {
        this.bz = bz;
    }

    public String getFzr() {
        return fzr;
    }

    public String getBz() {
        return bz;
    }

    public String getKhdmm() {
        return khdmm;
    }

    public void setKhdmm(String khdmm) {
        this.khdmm = khdmm;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getPort() {
        return port;
    }

    public void setPort(String port) {
        this.port = port;
    }


    public String getJrdzt() {
        return jrdzt;
    }

    public void setJrdzt(String jrdzt) {
        this.jrdzt = jrdzt;
    }

    public Date getZtgxsj() {
        return ztgxsj;
    }

    public void setZtgxsj(Date ztgxsj) {
        this.ztgxsj = ztgxsj;
    }

    @Override
    public String toString() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String resStr = "{客户端编码=" + khdbm + ",客户端密码=" + khdmm +  ",IP=" + ip +
                ",端口号=" + port + ",区县代码=" + qxdm + ",区县名称=" + qxmc
                + ",接入时间=" + sdf.format(jrsj) + ",负责人=" + fzr + ",IP=" + ip+ ",队列名称=" + dlmc +",端口=" + port +"}";
        return resStr;
    }


}
