package cn.gtmap.realestate.supervise.server.entity;

import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
 * @version 1.0, 2017/4/11
 * @description 规则管理实体类
 */
@Entity
@Table(name = "ba_rule")
public class CheckRule  implements Serializable{

    @Id
    private String id;

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @description 规则代码
     */
    private String rulecode;

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @description 规则名称
     */
    private String rulename;

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @description 是否需要检查
     */
    private String ischeck;

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @description 权重，应该已废除
     */
    private int weight;

    public String getRulecode() {
        return rulecode;
    }

    public void setRulecode(String rulecode) {
        this.rulecode = rulecode;
    }

    public String getRulename() {
        return rulename;
    }

    public void setRulename(String rulename) {
        this.rulename = rulename;
    }

    public String getIscheck() {
        return ischeck;
    }

    public void setIscheck(String ischeck) {
        this.ischeck = ischeck;
    }

    public int getWeight() {
        return weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String toString() {
        String resStr = "{规则编码=" + rulecode + "规则名称=" + rulename + ",是否启用=" + ischeck +"}";
        return resStr;
    }
}
