package cn.gtmap.realestate.supervise.server.entity;

import javax.xml.bind.annotation.*;
import java.io.Serializable;

/**
 * @author <a href="mailto:gaofeng@gtmap.cn">gaofeng</a>
 * @version 1.0, 2017/11/3
 * @description
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(propOrder = {"areaCode","areaName","accessDate","remark","registerInfo","accessInfo"})
public class AccessLog implements Serializable {

    @XmlElement(name = "AreaCode")
    private String areaCode;

    @XmlElement(name = "AreaName")
    private String areaName;

    @XmlElement(name = "AccessDate")
    private String accessDate;

    @XmlElement(name = "Remark")
    private String remark;

    //区县登簿信息 businessTypeCount 字段有值
    @XmlElement(name = "RegisterInfo")
    private RegisterInfo registerInfo;

    //接入上报信息 businessTypeCount 字段无值
    @XmlElement(name = "AccessInfo")
    private AccessInfo accessInfo;

    @XmlTransient
    private String sbzt;//0:失败，1：成功

    @XmlTransient
    private String sfbb  ;//true:成功，false：失败

    public String getSfbb() {
        return sfbb;
    }

    public void setSfbb(String sfbb) {
        this.sfbb = sfbb;
    }

    public String getAreaCode() {
        return areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    public String getAreaName() {
        return areaName;
    }

    public void setAreaName(String areaName) {
        this.areaName = areaName;
    }


    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public RegisterInfo getRegisterInfo() {
        return registerInfo;
    }

    public void setRegisterInfo(RegisterInfo registerInfo) {
        this.registerInfo = registerInfo;
    }

    public AccessInfo getAccessInfo() {
        return accessInfo;
    }

    public void setAccessInfo(AccessInfo accessInfo) {
        this.accessInfo = accessInfo;
    }

    public String getAccessDate() {
        return accessDate;
    }

    public void setAccessDate(String accessDate) {
        this.accessDate = accessDate;
    }

    public String getSbzt() {
        return sbzt;
    }

    public void setSbzt(String sbzt) {
        this.sbzt = sbzt;
    }
}
