package cn.gtmap.realestate.supervise.server.dao.mapper;

import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

/**
 * @version 1.0 2019-7-19
 * @auther <a href="mailto:xutao@gtmap.cn">xutao</a>
 * @description
 */
@Repository
public interface KxlMapper {

    /**
     * 获取市级-建设用地使用权
     * @param param
     * @return
     */
    List<Map<String, Object>> listCityJsydsyq(Map<String, Object> param);

    /**
     * 获取市级-房屋使用权
     * @param param
     * @return
     */
    List<Map<String, Object>> listCityFwsyq(Map<String, Object> param);

    /**
     * 获取市级-查封
     * @param param
     * @return
     */
    List<Map<String, Object>> listCityCf(Map<String, Object> param);

    /**
     * 获取市级-抵押
     * @param param
     * @return
     */
    List<Map<String, Object>> listCityDy(Map<String, Object> param);

    /**
     * 获取市级-预告
     * @param param
     * @return
     */
    List<Map<String, Object>> listCityYg(Map<String, Object> param);

    /**
     * 获取县级-建设用地使用权
     * @param param
     * @return
     */
    List<Map<String, Object>> listCountyJsydsyq(Map<String, Object> param);

    /**
     * 获取县级-房屋使用权
     * @param param
     * @return
     */
    List<Map<String, Object>> listCountyFwsyq(Map<String, Object> param);

    /**
     * 获取县级-查封
     * @param param
     * @return
     */
    List<Map<String, Object>> listCountyCf(Map<String, Object> param);

    /**
     * 获取县级-抵押
     * @param param
     * @return
     */
    List<Map<String, Object>> listCountyDy(Map<String, Object> param);

    /**
     * 获取县级-预告
     * @param param
     * @return
     */
    List<Map<String, Object>> listCountyYg(Map<String, Object> param);

    /**
     * 更新建设用地使用权上报状态
     * @param param
     * @return
     */
    int updateJsydsyqSbzt(Map<String, Object> param);

    /**
     * 更新房屋使用权上报状态
     * @param param
     * @return
     */
    int updateFwsyqSbzt(Map<String, Object> param);

    /**
     * 更新查封上报状态
     * @param param
     * @return
     */
    int updateCfSbzt(Map<String, Object> param);

    /**
     * 更新抵押上报状态
     * @param param
     * @return
     */
    int updateDySbzt(Map<String, Object> param);

    /**
     * 更新预告上报状态
     * @param param
     * @return
     */
    int updateYgSbzt(Map<String, Object> param);

    /**
     * 行政区划
     * @param qhdm
     * @return
     */
    List<Map<String, Object>> listXzqh(String qhdm);

    /**
     * 获取上一次结束时间
     * @return
     */
    String getlastJssj();

    /**
     * 保存操作记录
     * @return
     */
    int saveDataCz(Map<String, Object> param);
}
