package cn.gtmap.realestate.supervise.server.dao.mapper;

import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

@Repository
public interface JrdbzlpjMapper {

    /**
     * 获取接入质量评价数据
     * @param map
     * @return
     */
    List<Map<String, String>> getJrzlpjData(Map<String, String> map);

    /**
     * 接入质量评价数据按照市汇总
     * @param map
     * @return
     */
    List<Map<String, String>> getJrzlpjHzByCity(Map<String, String> map);

    /**
     * 获取未上传数据区县
     * @param kssj
     * @param jssj
     * @return
     */
    List<Map<String,String>> getWscsjqx(@Param("kssj")String kssj, @Param("jssj")String jssj);

    /**
     * 获取未登薄区县数量
     * @param kssj
     * @param jssj
     * @return
     */
    List<Map<String,String>> getWdbqxsl(@Param("kssj") String kssj,@Param("jssj") String jssj);


    Map<String, String> getRegion(@Param("qhdm") String qhdm);

    /**
     * 保存统计数据
     * @param kssj 开始时间
     * @param jssj 结束时间
     */
    void saveCountData(@Param("kssj") String kssj,@Param("jssj") String jssj);

    /**
     * 获取大市
     * @param qhdm
     * @return
     */
    List<Map<String, String>> getCity(@Param("qhdm") String qhdm);

    /**
     * 更新操作时间
     * @param kssj
     * @param jssj
     */
    void updateTjczrz(@Param("kssj") String kssj,@Param("jssj") String jssj);

    /**
     * 获取未上传区县数量
     * @param qhdm 区划代码
     * @param kssj 开始时间
     * @param jssj 结束时间
     * @return
     */
    int getWscsjqxCount(@Param("qhdm") String qhdm, @Param("kssj") String kssj,@Param("jssj") String jssj);

    /**
     * 获取未登薄区县数量
     * @param qhdm 区划代码
     * @param kssj 开始时间
     * @param jssj 结束时间
     * @return
     */
    int getWdbqxslCount(@Param("qhdm") String qhdm, @Param("kssj") String kssj,@Param("jssj") String jssj);

    /**
     * 导出明细
     * @param map
     * @return
     */
    List<Map<String, String>> getDetail(Map<String, String> map);
    List<String> getDbywh(Map<String, String> map);

    List<String> getCfdjYwh(Map<String, String> map);
    List<String> getDyaqYwh(Map<String, String> map);
    List<String> getDyiqYwh(Map<String, String> map);
    List<String> getFdcq1Ywh(Map<String, String> map);
    List<String> getFdcq2Ywh(Map<String, String> map);
    List<String> getGjzwsyqYwh(Map<String, String> map);
    List<String> getHysyqYwh(Map<String, String> map);
    List<String> getJsydsyqYwh(Map<String, String> map);
    List<String> getLqYwh(Map<String, String> map);
    List<String> getNydsyqYwh(Map<String, String> map);
    List<String> getQtxgqlYwh(Map<String, String> map);
    List<String> getTdsyqYwh(Map<String, String> map);
    List<String> getYgdjYwh(Map<String, String> map);
    List<String> getYydjYwh(Map<String, String> map);
    List<String> getCfdj2Ywh(Map<String, String> map);
    List<String> getDyaq2Ywh(Map<String, String> map);
    List<String> getYgdj2Ywh(Map<String, String> map);
    List<String> getYydj2Ywh(Map<String, String> map);
    List<String> getZxdjYwh(Map<String, String> map);

    /**
     * 获取区县列表
     * @param
     * @return
     */
    List<Map<String,String>> getQx();

    /**
     * 获取大市列表
     * @param
     * @return
     */
    List<Map<String,String>> getDs(String qhdm);

    /**
     * 获取所有城市
     * @param
     * @return
     */
    List<Map<String,String>> getAllRegion();



    /**
     * 获取所有地级城市
     * @param
     * @return
     */
    List<Map<String,String>> getAllDJRegion();



}
