package cn.gtmap.realestate.supervise.server.dao.mapper;

import cn.gtmap.realestate.supervise.entity.*;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:gaofeng@gtmap.cn">gaofeng</a>
 * @version 1.0, 2017/11/9
 * @description  登记权利数据访问层
 */
@Repository
public interface DjqlMapper {


    /**
     * 获取抵押权
     * @param param
     * @return
     */
    List<BaDyaq> getDyaqList(Map<String,Object> param);

    /**
     * 获取查封登记数据
     * @param param
     * @return
     */
    List<BaCfdj> getCfdjList(Map<String,Object> param);

    /**
     * 获取地役权
     * @param param
     * @return
     */
    List<BaDyiq> getDyiqList(Map<String,Object> param);

    /**
     * 获取预告登记权利信息
     * @param param
     * @return
     */
    List<BaYgdj> getYgdjList(Map<String,Object> param);


    /**
     * 获取房地产权（项目内多幢房屋）数据
     * @param param
     * @return
     */
    List<BaFdcq1> getFdcq1List(Map<String,Object> param);


    /**
     *  房地产权（独幢、层、套、间房屋）
     * @param param
     * @return
     */
    List<BaFdcq2> getFdcq2List(Map<String,Object> param);

}
