package cn.gtmap.realestate.supervise.server.dao.mapper;

import cn.gtmap.realestate.supervise.server.entity.Qxtjxx;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:gaofeng@gtmap.cn">gaofeng</a>
 * @version 1.0，2017/4/13
 * @description
 */
@Repository
public interface BaXzqhMapper {

    public List<Map<String,String>> getXzqhDatas(Map<String,String> map);


    /**
     * 获取每个地区汇总信息
     * @return
     */
//    public List<Map<String,Object>> getDatasInfos();

    /**
     * 获取总体汇总信息
     * @return
     */
//    public List<Map<String,Object>> getTotalInfos();

    /**
     * 获取每个地区当天汇总信息
     * @return
     */
//    public List<Map<String,Object>> getCurDatasInfos();

    /**
     * 获取总体当天汇总信息
     * @return
     */
//    public List<Map<String,Object>> getTotalCurInfos();


    /**
     * 获取质量信息配置项
     * @return
     */
    public List<Map<String,Object>> getZlInfos();

    /**
     * 获取地图位置
     *  @param qhdmAndFdm
     * @return
     */
    public List<Map<String,Object>> getGeocoord(Map qhdmAndFdm);


    /**
     * 获取每个地区成功总数
     * @return
     */
//    public List<Map<String,Object>> getDatasCgjlInfos();

    /**
//     * 删除统计信息表
//     */
//    public void deleteTjxx();

    /**
//     * 删除地区统计信息
//     */
//    public void deleteDqtjxx();


    /**
//     * 插入统计信息
//     * @param param
//     */
//    public void insertTjxx(Map<String,Object> param);
//
//    /**
//     * 插入地区统计信息
//     * @param param
//     */
//    public void insertDqtjxx(Map<String,Object> param);


    /**
     * 查询总统计信息
     * @return
     */
//    public List<Map<String,Object>> getTjxx();


    /**
     * 查询地区统计信息
     * @return
     */
    public List<Map<String,Object>> getDqtjxx(@Param(value = "qhmc") String qhmc);

    /**
     * 根据行政区代码查询统计信息
     * @param param
     * @return
     */
    Qxtjxx getQxtjxx(Map<String,Object> param);


    /**
     * 根据region.qhdm、查询市级信息
     * @param qhdm
     * @return
     */
     List<Map<String,Object>> getDsxx(String qhdm);

    /**
     * 根据父代码查询区县信息
     * @param fdm
     * @return
     */
    List<Map<String,Object>> getQxxxByFdm(String fdm);

    /**
     * 根据区划代码获取区划信息
     * @param qhdm
     * @return
     */
    String getCityInfoByqhdm(String qhdm);


    /**
     * 获取地图显示信息
     * @param param
     * @return
     */
    List<Map<String,Object>> getCityInfos(Map param);

    /**
     * 查询接入点信息
     * @return
     */
    List<Map<String,String>> getJrdxx();


    /**
     * 根据qhdm获取接入点状态
     * @param qhdm
     * @return
     */
    List<Map<String,String>> getJrdxxByQhdm(String qhdm);


    /**
     * 获取行政区信息
     * @param qhdm
     * @return
     */
    List<Map<String,Object>> getXzqhxx(@Param(value = "qhdm") String qhdm);


    /**
     * 获取未上传数据区县数量
     * @param qhdm
     * @param kssj
     * @param jssj
     * @return
     */
    int getWscsjqx(@Param("qhdm") String qhdm, @Param("kssj")String kssj, @Param("jssj")String jssj);


    /**
     * 根据qhdm获取接入点关联行政区信息
     * @param qhdm
     * @return
     */
    List<Map<String,String>> getJrdQxxxByQhdm(String qhdm);


    /**
     * 插入区县统计信息
     * @param qxtjxx
     */
    void  insertQxtjxx(Qxtjxx qxtjxx);

    /**
     * 更新区县统计信息
     * @param qxtjxx
     */
    void updateQxtjxx(Qxtjxx qxtjxx);

    /**
     * 获取xt_region所有数据
     */
    List<Map<String,String>> getXtregion();

    /**
     * 根据qhmc查询大市信息
     * @param qhmc
     * @return
     */
    List<Map<String,Object>> getDsxxByQhmc( String qhmc);


    /**
     * 获取未上传数据区县数量
     * @param qhdm
     * @param kssj
     * @param jssj
     * @return
     */
    int getRocketMqWscsjqx(@Param("qhdm") String qhdm, @Param("kssj")Date kssj, @Param("jssj")Date jssj);

    /**
     * 总接入数量
     * @param qhdm
     * @return
     */
    int getZjrl(@Param("qhdm")String qhdm);

    /**
     * 通过区划代码获取区划名称
     * @param qhdm
     * @return
     */
    String getQhmcByqhdm(String qhdm);

    /**
     * 通过区划代码获取父代码
     * @param qhdm
     * @return
     */
    String getFDMByqhdm(String qhdm);


    /**
     * 陕西接入首页重做 (部分)
     * 根据区划代码获得地级市的接入总量
     * @param
     * @return
     */
    String getSumJrzl(Map map);


    /**
     * 陕西接入首页重做 (部分)
     * 成功接入量
     * @param qhdm
     * @return
     */
    String getCgjrsl(Map<String,String> qhdm);


    /**
     * 根据qhmc 获得qhdm
     * @param QHMC
     * @return
     */

    String  getQhdmByMc( @Param("qhmc")String QHMC);




}
