package cn.gtmap.realestate.supervise.server.dao.mapper;

import cn.gtmap.realestate.supervise.server.entity.PublicRzJl;
import cn.gtmap.realestate.supervise.server.entity.Rzjl;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:gaofeng@gtmap.cn">gaofeng</a>
 * @version 1.0, 2017/5/4
 * @description ba_sftp_rzjl 表查询
 */
@Repository
public interface BaSftpMapper {

    /**
     * 上报数量统计
     *
     * @param map
     * @return
     */
    List<Map<String, String>> getSbslData(Map<String, String> map);

    /**
     * 上报情况监控
     *
     * @param map
     * @return
     */
    List<Map<String, String>> getSbqkData(Map<String, String> map);


    /**
     * 删除报文信息
     *
     * @param id
     */
    public void delBwInfos(String id);


    /**
     * 更新上报日志状态
     *
     * @param updateMap
     */
    public void updateSftpRzjl(Map<String, String> updateMap);

    /**
     * 更新日志失败结果
     *
     * @param updateMap
     */
    public void updateSftpRzjlSbjg(Map<String, String> updateMap);


    /**
     * 获取上报数量
     *
     * @param map
     * @return
     */
    List<Map<String, String>> getSbslInfos(Map<String, String> map);


    /**
     * 根据大市区划代码统计大市接入数据
     *
     * @param map
     * @return
     */
    Map<String, String> getDsxxByQhdm(Map<String, String> map);


    /**
     * 根据父代码查询区县信息
     *
     * @param map
     * @return
     */
    List<Map<String, String>> getQxxxByFdm(Map<String, String> map);


    /**
     * 根据父代码统计大市每天接入数量信息
     *
     * @param param
     * @return
     */
    List<Map<String, String>> getJrqkjkCityData(Map<String, String> param);


    /**
     * 获取上报概况
     *
     * @return
     */
    Map<String, Object> getSbgkData(@Param(value = "qhmc") String qhmc);


    /**
     * 获取日志记录信息
     *
     * @param fileName
     * @return
     */
    PublicRzJl getSftpRzjlInfos(String fileName);


    /**
     * 手动上报成功更新上报结果状态
     *
     * @param fileName
     */
    void updateSbjgByFileName(String fileName);

    /**
     * 报省成功，日志更新
     *
     * @param fileName
     */
    void updateBscg(String fileName);


    /**
     * 报省失败，日志更新
     *
     * @param fileName
     */
    void updateBssb(String fileName);

    /**
     * 上报失败更新zt字段
     *
     * @param fileName
     */
    void updateEjsbZt(String fileName, String ejsbjg);


    /**
     * 查询ba_sftp_rzjl表、根据ywh和bdcdyh去重
     *
     * @param param
     * @return
     */
    int getSbsl(Map<String, Object> param);

    /**
     * 获取上报成功数量
     *
     * @return
     */
    int getSbcgsl(Map<String, Object> param);

    /**
     * 校验是否有数据
     *
     * @param tableName
     * @param zdmc
     * @param ywh
     * @return
     */
    int checkData(@Param(value = "tableName") String tableName, @Param(value = "zdmc") String zdmc, @Param(value = "ywh") String ywh);


    /**
     * 校验是否有数据
     *
     * @param tableName
     * @param zdmc
     * @param ywh
     * @return
     */
    int checkOtherData(@Param(value = "tableName") String tableName, @Param(value = "zdmc") String zdmc, @Param(value = "ywh") String ywh);


    /**
     * 校验是否有数据
     *
     * @param tableName
     * @param ywh
     * @return
     */
    int checkBdbzzqseData(@Param(value = "tableName") String tableName, @Param(value = "ywh") String ywh);


    /**
     * 根据业务号查询fdcq1
     *
     * @param params
     * @return
     */
    List<Map<String, Object>> getFdcq1List(Map<String, Object> params);


    /**
     * 查询抵押权表
     *
     * @param params
     * @return
     */
    List<Map<String, Object>> getDyaqList(Map<String, Object> params);

    /**
     * 根据文件名查询上报日志记录表信息
     * @param fileName
     * @return
     */
    List<Map<String,String>> getSftpRzjl(String fileName);

    /**
     * 根据文件名查询rzjl
     * @param fileName
     * @return
     */
    List<Rzjl> getRzjlList(String fileName);

    /**
     * 更新未上报状态
     * @param fileName
     */
    void updateWsbByFileName(String fileName);
}
