package cn.gtmap.realestate.supervise.server.dao.mapper;

import cn.gtmap.realestate.supervise.server.entity.*;
import cn.gtmap.realestate.supervise.server.entity.Error;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:gaofeng@gtmap.cn">gaofeng</a>
 * @version 1.0, 2017/5/4
 * @description ba_rzjl 表查询
 */
@Repository
public interface BaRzjlMapper {
    public List<Count> getCountByJRDM(Map<String, Object> map);

    public List<Error> getCountErrorByJRDM(Map<String, Object> map);

    public List<ErrorDetail> getCountErrorDetailByJRDM(Map<String, Object> map);

    public List<Map<String, String>> getBwInfosByPage(Map<String, Object> param);

    public List<Map<String, String>> getJrslDataMaps(Map<String, String> map);

    public List<LinkedHashMap<String, String>> getJrsl(Map<String, String> map);

    public List<Map<String, String>> getJrqkDataMaps(Map<String, String> map);

    /**
     * 获取区县接入监控信息
     *
     * @param param
     * @return
     */
    public Qxjrjkxx getQxjrjkxx(Map<String, Object> param);

    /**
     * 获取区县上报监控信息
     *
     * @param param
     * @return
     */
    public Qxsbjkxx getQxsbjkxx(Map<String, Object> param);


    /**
     * 获取接入数量监控情况
     *
     * @param map
     * @return
     */
    List<Map<String, String>> getJrslInfos(Map<String, String> map);


    /**
     * @return
     * @author <a href="mailto:chentao@gtmap.cn">chentao</a>
     * @description 获取城市列表(xt_region)
     */
    List<Map<String, String>> getCityList();

    /**
     * @param fdm 父代码
     * @return List<Map   <   String   ,       String>>
     * @author <a href="mailto:chentao@gtmap.cn">chentao</a>
     * @description 根据fDM获取对应的区县列表
     */
    List<Map<String, String>> getAreaList(String fdm);


    /**
     * 根据父代码查询区县信息
     *
     * @param map
     * @return
     */
    List<Map<String, String>> getQxxxByFdm(Map<String, String> map);

    /**
     * 根据大市区划代码统计大市接入数据
     *
     * @param map
     * @return
     */
    Map<String, String> getDsxxByQhdm(Map<String, String> map);

    /**
     * 根据父代码统计大市每天接入数量信息
     *
     * @param param
     * @return
     */
    List<Map<String, String>> getJrqkjkCityData(Map<String, String> param);

    String getfhbwErrMsg(String id);

    /**
     * 获取需要归档信息
     *
     * @param param
     * @return
     */
    List<Rzjl> getGdxx(Map<String, Object> param);


    /**
     * 系统首页获取每小时接入情况
     *
     * @return
     */
    List<Map<String, Object>> getJrqkList(@Param(value = "qhmc") String qhmc, @Param(value = "dateTime") String dateTime);

    /**
     * 获取接入统计情况接入数量信息
     *
     * @param qhdm
     * @param kssj
     * @param jssj
     * @return
     */
    Map<String, Object> getJrtjqkJrsl(@Param("qhdm") String qhdm, @Param("kssj") String kssj, @Param("jssj") String jssj);

    /**
     * 更新入库状态
     *
     * @param fileName
     */
    boolean updateRkzt(String fileName);

    /**
     * 根据文件名查询数据
     *
     * @param fileName
     * @return
     */
    List<Rzjl> getRzjlByFileName(String fileName);

    /**
     * 插入区县接入监控信息
     *
     * @param qxjrjkxx
     */
    void insertQxjrjkxx(Qxjrjkxx qxjrjkxx);

    /**
     * 更新区县接入监控信息
     *
     * @param qxjrjkxx
     */
    void updateQxjrjkxx(Qxjrjkxx qxjrjkxx);


    /**
     * 区县上报监控信息
     *
     * @param qxsbjkxx
     */
    void insertQxsbjkxx(Qxsbjkxx qxsbjkxx);

    /**
     * 更新区县上报监控信息
     *
     * @param qxsbjkxx
     */
    void updateQxsbjkxx(Qxsbjkxx qxsbjkxx);


    /**
     * 更新成功数量字段
     *
     * @param qxsbjkxx
     */
    void updateQxsbjkxxCgsl(Qxsbjkxx qxsbjkxx);

    /**
     * 接入上报数量统计
     *
     * @param param
     * @return
     */
    Map<String, String> getJrsbslData(Map<String, String> param);

    /**
     * 查询区县接入上报数量
     *
     * @param param
     * @return
     */
    List<Map<String, String>> getJrsbslByFdm(Map<String, String> param);

    /**
     * 查询区县接入上报数量
     * 陕西新需求 展示无数据的区县
     * @param param
     * @return
     */
    List<Map<String, String>> getJrsbslByFdmNotRemoveNull(Map<String, String> param);


    /**
     * 接入上报情况监控
     *
     * @param param
     * @return
     */
    List<Map<String, String>> getJrsbqkData(Map<String, String> param);

    /**
     * 接入上报情况监控
     * 陕西新需求 展示无数据的区县
     * @param param
     * @return
     */
    List<Map<String, String>> getJrsbqkDataNotRemoveNull(Map<String, String> param);


    /**
     * 获取接入统计情况接入数量信息
     *
     * @param qhdm
     * @param kssj
     * @param jssj
     * @return
     */
    Map<String, Object> getRocketMqJrqktjxx(@Param("qhdm") String qhdm, @Param("kssj") Date kssj, @Param("jssj") Date jssj);

    /**
     * 统计上线总天数
     * @param startDate
     * @return
     */
    int getTotalDays(@Param("startDate") Date startDate);

    /**
     * 成功数量
     * @param param
     * @return
     */
    int getCgsl(Map<String,Object> param);

    /**
     * 失败数量
     * @param param
     * @return
     */
    int getSbsl(Map<String,Object> param);


    /**
     * 接入上报数量统计
     *
     * @param param
     * @return
     */
    Map<String, String> getQxJrsbslData(Map<String, String> param);


    /**
     * 查询业务号
     * @param params
     * @return
     */
    List<Rzjl> getYwhList(Map<String, Object> params);


    /**
     * 新首页接入信息
     * @param params
     * @return
     */
    List<Map<String, Object>> getRocketMqnewJrqktjxx(Map<String, Object> params);
}
