package cn.gtmap.realestate.supervise.server.dao.mapper;

import cn.gtmap.realestate.supervise.entity.*;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * Created by Administrator on 2018/5/18.
 * 常州加密数据统一修复数据访问层
 */
@Repository
public interface BaAesMapper {

    /**
     * 查询Fdcq1 数据
     *
     * @return
     */
    List<BaFdcq1> listFdcq1Infos();

    /**
     * 更新
     *
     * @param baFdcq1
     */
    void updateFdcq1Info(BaFdcq1 baFdcq1);


    /**
     * 查询ba_dyaq数据
     *
     * @return
     */
    List<BaDyaq> listDyaqInfos();

    /**
     * 更新ba_dyaq数据
     *
     * @param baDyaq
     */
    void updateDyaqInfo(BaDyaq baDyaq);


    /**
     * 查询 ba_qlr 数据
     *
     * @return
     */
    List<Qlr> listQlrInfos(@Param(value = "start") String start, @Param(value = "end") String end);

    /**
     * 更新 ba_qlr 数据
     *
     * @param baQlr
     */
    void updateQlrInfo(Qlr baQlr);


    /**
     * 查询 ba_sqr 数据
     *
     * @return
     */
    List<BaSqr> listSqrInfos();

    /**
     * 更新 ba_sqr 数据
     *
     * @param baSqr
     */
    void updateSqrInfo(BaSqr baSqr);


    /**
     * 查询 ba_fdcq2 数据
     *
     * @return
     */
    List<BaFdcq2> listFdcq2Infos();

    /**
     * 更新 ba_fdcq2 数据
     *
     * @param baFdcq2
     */
    void updateFdcq2Info(BaFdcq2 baFdcq2);

}
