package cn.gtmap.realestate.supervise.server.dao.mapper;

import cn.gtmap.realestate.supervise.entity.XtRegion;
import cn.gtmap.realestate.supervise.server.entity.AccessInfo;
import cn.gtmap.realestate.supervise.server.entity.AccessLog;
import cn.gtmap.realestate.supervise.server.entity.RegisterInfo;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:gaofeng@gtmap.cn">gaofeng</a>
 * @version 1.0, 2017/11/9
 * @description 登薄信息数据访问层
 */
@Repository
public interface BaAccessLogMapper {


    List<Map<String, Object>> getJrrzInfosByPage(Map<String, Object> param);


    /**
     * 获取区县登簿信息
     * businessTypeCount 字段有值记录
     *
     * @param areacode
     * @return
     */
    RegisterInfo getRegisterInfo(@Param("areacode")String areacode,@Param("date")String date);

    /**
     * businessTypeCount 字段无值记录
     * 接入上报信息记录
     *
     * @param areacode
     * @return
     */
    AccessInfo getAccessInfo(@Param("areacode")String areacode,@Param("date")String date);


    /**
     * 获取未登薄区县数量
     *
     * @param qhdm
     * @param kssj
     * @param jssj
     * @return
     */
    int getWdbqxsl(@Param("qhdm") String qhdm, @Param("kssj") String kssj, @Param("jssj") String jssj);


    /**
     * 删除数据
     *
     * @param areaCode
     * @param accessDate
     */
    void delAccesslog(@Param("areaCode") String areaCode, @Param("areaName") String areaName, @Param("accessDate") Date accessDate);


    /**
     * 更新报部失败状态
     *
     * @param accessLog
     */
    void updateSbjg(AccessLog accessLog);

    /**
     * 区县登簿信息 businessTypeCount 字段有值
     *
     * @param areaCode
     * @param date
     * @return
     */
    RegisterInfo getRegisterInfoByCode(@Param("areaCode") String areaCode, @Param("date") String date);

    /**
     * 区县接入上报信息 businessTypeCount 字段无值
     *
     * @param areaCode
     * @param date
     * @return
     */
    AccessInfo getAccessInfoByCode(@Param("areaCode") String areaCode, @Param("date") String date);

    /**
     * 根据qhdm获取xtregion信息
     *
     * @param qhdm
     * @return
     */
    XtRegion getRegionByCode(@Param("qhdm") String qhdm);

    /**
     * 根据地区和日期选择 remark最大的值
     *
     * @param areaCode
     * @param date
     * @return
     */
    Map<String,String> getMaxRemark(@Param("areaCode") String areaCode, @Param("date") String date);



    /**
     * 根据4个参数查询是否存在记录 登薄量
     *
     * @param
     * @param
     * @return
     */

    RegisterInfo getBalogDBL(Map<String,Object> paramMap);


    /**
     * 根据4个参数查询是否存在记录 接入量
     *
     * @param
     * @param
     * @return
     */
    AccessInfo getBalogJRL(Map<String,Object> paramMap);


    /**
     * 更新报部状态
     * @param
     */
    void updatebbresult(AccessLog accessLog);

    /**
     * 根据 areacode和sfbb为false 找到要上报的时间
     * @param paramMap
     * @return
     */
   List<String> getAccessDates(Map<String,String> paramMap);



}
