package cn.gtmap.realestate.supervise.server.dao.impl;

import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.mapper.Example;
import cn.gtmap.realestate.supervise.server.dao.SignDao;
import cn.gtmap.realestate.supervise.server.entity.Sign;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author <a href="mailto:tianjian@gtmap.cn">tianjain</a>
 * @version 1.0, 2017/5/17
 * @description 数据签名功能，数据访问层实现类
 */
@Service
public class SignDaoImpl implements SignDao {

    @Autowired
    EntityMapper entityMapper;

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @param sign 需要查询的数字签名
     * @return true 成功，false 失败
     * @description 按照给的数字签名查找是否存在。
     */
    @Override
    public boolean findBySign(String sign) {
        boolean flag = false;
        if (sign == null) {
            return flag;
        }
        Example example = new Example(Sign.class);
        example.createCriteria().andEqualTo("sign", sign);
        List<Sign> signs = entityMapper.selectByExample(example);
        if (signs != null && !signs.isEmpty()) {
            flag = true;
        }
        return flag;
    }

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @param sign 需要插入的数字签名
     * @return true 插入成功，false 插入失败
     * @description 将已验证通过的文件数字签名入库，作为下次数字签名验重的依据
     */
    @Override
    public boolean insertSign(Sign sign) {
        return entityMapper.insert(sign) > 0;
    }

}
