package cn.gtmap.realestate.supervise.server.dao.impl;

import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.realestate.supervise.server.dao.InsertSingleTableDao;
import cn.gtmap.realestate.supervise.server.model.SimpleTableResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
 * @version 1.0, 2017/4/1
 * @description 单表插入数据库的实现
 */
@Service
public class InsertSingleTableDaoImpl implements InsertSingleTableDao {


    @Autowired
    EntityMapper entityMapper;

    /**
     * @param objs 需要插入数据库的实体类
     * @return 插入数据库的结果
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @description 通过单表插件将数据插入到数据库
     */
    @Override
    public SimpleTableResult insertSingleTable(List<Object> objs){

        entityMapper.batchSaveSelective(objs);
        return new SimpleTableResult();
    }

}
