package cn.gtmap.realestate.supervise.server.dao.impl;

import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.realestate.supervise.server.dao.InsertGraphicInfo;
import cn.gtmap.realestate.supervise.server.entity.GraphicInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * Created by tianjian on 2017/7/26.
 */
@Service
public class InsertGraphicInfoImpl implements InsertGraphicInfo {
    @Autowired
    EntityMapper entityMapper;

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @param graphicInfo 需要插入的图形信息
     * @return true 成功 false 失败
     * @description 将图形特征码插入数据库中
     */
    @Override
    public boolean insertGraphicInfo(GraphicInfo graphicInfo) {
        return entityMapper.saveOrUpdate(graphicInfo, graphicInfo.getId()) > 0;
    }
}
