package cn.gtmap.realestate.supervise.server.dao.impl;

import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.realestate.supervise.entity.BaZdjbxx;
import cn.gtmap.realestate.supervise.entity.BaZdk103;
import cn.gtmap.realestate.supervise.entity.BaZhjbxx;
import cn.gtmap.realestate.supervise.entity.BaZhk105;
import cn.gtmap.realestate.supervise.server.config.Constant;
import cn.gtmap.realestate.supervise.server.dao.GetAllMapInfoByBdcdyh;
import cn.gtmap.realestate.supervise.server.utils.ExampleUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
 * @version 1.0, 2017/7/22
 * @description 获取所有不动产单元号图形信息
 */
@Service
public class GetAllMapInfoByBdcdyhImpl implements GetAllMapInfoByBdcdyh{

    @Autowired
    EntityMapper entityMapper;

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @param bdcdyh 不动产单元号（宗海）
     * @return 特定不动产单元号的坐标具体数据，特别是坐标点信息
     * @description 获取宗海坐标点信息
     */
    public List<BaZhk105> getBaZhk105Info(String bdcdyh) {
        Map param = new HashMap<String,String>();
        param.put(Constant.BDCDYH, bdcdyh);
        ExampleUtil example = new ExampleUtil(BaZhk105.class, param);
        example.setOrderByClause(" to_number(xh) ");
        return entityMapper.selectByExample(example);
    }

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @param bdcdyh 不动产单元号（宗地）
     * @return 特定不动产单元号的坐标具体数据，特别是坐标点信息
     * @description 获取宗地坐标点信息
     */
    @Override
    public List<BaZdk103> getBaZdk103Info(String bdcdyh) {
        Map param = new HashMap<String,String>();
        param.put(Constant.BDCDYH, bdcdyh);
        ExampleUtil example = new ExampleUtil(BaZdk103.class, param);
        example.setOrderByClause(" to_number(" + Constant.XH + ") ");
        return entityMapper.selectByExample(example);
    }


    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @param bdcdyh 不动产单元号（宗海）
     * @return 宗海基本信息
     * @description 按照不动产单元号获取宗海基本信息
     */
    @Override
    public List<BaZhjbxx> getZhXX(String bdcdyh) {
        Map param = new HashMap<String,String>();
        param.put(Constant.BDCDYH, bdcdyh);
        ExampleUtil example = new ExampleUtil(BaZhjbxx.class, param);
        entityMapper.selectByExample(example);
        return entityMapper.selectByExample(example);
    }


    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @param bdcdyh 不动产单元号（宗地）
     * @return 宗地基本信息
     * @description 按照不动产单元号后去宗地基本信息
     */
    @Override
    public List<BaZdjbxx> getZdXX(String bdcdyh) {
        Map param = new HashMap<String,String>();
        param.put(Constant.BDCDYH, bdcdyh);
        ExampleUtil example = new ExampleUtil(BaZdjbxx.class, param);
        entityMapper.selectByExample(example);
        return entityMapper.selectByExample(example);
    }

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @param baZdk103 需要跟新的宗地封装信息
     * @description 更新宗地基本信息
     */
    @Override
    public void updateBaZdk103(BaZdk103 baZdk103) {
        entityMapper.saveOrUpdate(baZdk103, baZdk103.getId());
    }

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @param baZhk105 需要跟新的宗海封装信息
     * @description 跟新宗海基本信息
     */
    @Override
    public void updateBaZhk105(BaZhk105 baZhk105) {
        entityMapper.saveOrUpdate(baZhk105, baZhk105.getId());
    }
}
