package cn.gtmap.realestate.supervise.server.dao.impl;

import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.realestate.supervise.server.config.Constant;
import cn.gtmap.realestate.supervise.server.dao.CheckGraphicByBdcdyh;
import cn.gtmap.realestate.supervise.server.dao.mapper.BaBdcdyhInfos;
import cn.gtmap.realestate.supervise.server.entity.CheckGraphicInfo;
import cn.gtmap.realestate.supervise.server.utils.ExampleUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by tianjian on 2017/7/26.
 */
@Service
public class CheckGraphicByBdcdyhImpl implements CheckGraphicByBdcdyh {
    @Autowired
    EntityMapper entityMapper;

    @Autowired
    BaBdcdyhInfos baBdcdyhInfos;
    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @param checkGraphicInfo:检查图形信息
     * @description 插入图形检查信息
     */
    @Override
    public void insertCheckGraphicInfo(CheckGraphicInfo checkGraphicInfo) {
        entityMapper.saveOrUpdate(checkGraphicInfo, checkGraphicInfo.getId());
    }

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @param bdcdyh 需要检查的不动产单元号
     * @return 返回图形信息
     * @description 根据不动产单元号获取图形信息标记
     */
    @Override
    public List<CheckGraphicInfo> getCheckGraphicInfo(String bdcdyh) {
        Map param = new HashMap<String,String>();
        param.put(Constant.BDCDYH, bdcdyh);
        ExampleUtil example = new ExampleUtil(CheckGraphicInfo.class, param);
        return entityMapper.selectByExample(example);

    }

    @Override
    public void delCheckGraphicInfo(String  bdcdyh) {
        Map param = new HashMap<String,String>();
        param.put(Constant.BDCDYH, bdcdyh);
        ExampleUtil example = new ExampleUtil(CheckGraphicInfo.class, param);
       entityMapper.deleteByExample(example);
    }

    @Override
    public void insertCheckGraphicInfos(CheckGraphicInfo info) {
        baBdcdyhInfos.insertCheckGraphicInfos(info);
    }

}
