package cn.gtmap.realestate.supervise.server.dao;

import cn.gtmap.realestate.supervise.server.entity.Sign;

/**
 * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
 * @version 1.0, 2017/5/17
 * @description 数字签名功能，数据访问层接口
 */
public interface SignDao {

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @param sign 需要查找的数字签名串
     * @return true 成功查找， false 没有找到
     * @description 验证重复的手段
     */
    boolean findBySign(String sign);

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @param sign 需要插入的数字签名的串
     * @return true 成功插入， false 插入失败
     * @description 将数字签名串插入到数据库
     */
    boolean insertSign(Sign sign);

}
