package cn.gtmap.realestate.supervise.server.dao;

import cn.gtmap.realestate.supervise.entity.BaZdjbxx;
import cn.gtmap.realestate.supervise.entity.BaZdk103;
import cn.gtmap.realestate.supervise.entity.BaZhjbxx;
import cn.gtmap.realestate.supervise.entity.BaZhk105;

import java.util.List;

/**
 * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
 * @version 1.0, 2017/7/22
 * @description 获取图形信息
 */
public interface GetAllMapInfoByBdcdyh {

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @param bdcdyh 不动产单元号
     * @return 宗海坐标点信息
     * @description 获取宗海坐标信息
     */
    List<BaZhk105> getBaZhk105Info(String bdcdyh);

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @param bdcdyh 不动产单元号
     * @return 宗地坐标点信息
     * @description 获取宗地坐标信息
     */
    List<BaZdk103> getBaZdk103Info(String bdcdyh);

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @param bdcdyh 不动产单元号
     * @return 不动产单元信息
     * @description 根据不动产单元号获取宗海基本信息
     */
    List<BaZhjbxx> getZhXX(String bdcdyh);

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @param bdcdyh 不动产单元号
     * @return 不动产单元信息
     * @description 根据不动产单元号获取宗地基本信息
     */
    List<BaZdjbxx> getZdXX(String bdcdyh);

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @param baZdk103 需要跟新的宗地信息
     * @return void
     * @description 更新宗地坐标点标记为已上图
     */
    void updateBaZdk103(BaZdk103 baZdk103);

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @param baZhk105 需要跟新的宗海信息
     * @return void
     * @description 更新宗海坐标点标记为已上图
     */
    void updateBaZhk105(BaZhk105 baZhk105);


}
