package cn.gtmap.realestate.supervise.server.dao;

import cn.gtmap.realestate.supervise.server.entity.CheckGraphicInfo;

import java.util.List;

/**
 * Created by tianjian on 2017/7/26.
 */
public interface CheckGraphicByBdcdyh {
    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @param checkGraphicInfo 插入图形信息
     * @return void
     * @description 插入图形特征信息
     */
    void insertCheckGraphicInfo(CheckGraphicInfo checkGraphicInfo);

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @param bdcdyh 不动产单元号
     * @return 对应不动产单元号图形特征信息
     * @description 按照不动产单元号获取图形特征信息
     */
    List<CheckGraphicInfo> getCheckGraphicInfo(String bdcdyh);

    /**
     * 删除记录
     * @param bdcdyh
     */
    void delCheckGraphicInfo(String  bdcdyh);

    /**
     * 插入数据
     * @param info
     */
    void insertCheckGraphicInfos(CheckGraphicInfo info);

}
