package cn.gtmap.realestate.supervise.server.config;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:gaofeng@gtmap.cn">gaofeng</a>
 * @version 1.0, 2017/10/12
 * @description 常量定义类
 */
public final class Constant {


    public static final String NODE_NAME = "nodename";

    public static final String CLASS_NAME = "classname";

//    public static final String ELEMENT_NAME = "element";

    public static final String ENTITY_PATH = "cn.gtmap.realestate.supervise.entity.";

    public static final String BA_GD_LS = "cn.gtmap.realestate.supervise.entity.BaGdLs";


    /**
     * 土地所有权首次登记
     */
    public static final String TDSYQSCDJ = "1000101";

    /**
     * 建设用地使用权、宅基地使用权首次登记
     */
    public static final String JSYDSYQSCDJ = "1000301";


    /**
     * 房地产权（项目内多幢房屋）首次登记
     */
    public static final String FDCQSCDJ1 = "1000401";

    /**
     * 房地产权（独幢、层、套、间、房屋）首次登记
     */
    public static final String FDCQSCDJ2 = "1000402";

    /**
     * 建筑物区分所有权业主共有部分首次登记
     */
    public static final String JZWQFSYQSCDJ = "1000403";

    /**
     * 海域(含无居民海岛)使用权首次登记
     */
    public static final String HYSYQSCDJ = "1001501";

    /**
     * 构（建）筑物所有权首次登记
     */
    public static final String GZWSYQSCDJ = "1001601";

    /**
     * 土地承包经营权、农用地使用权（非林地）首次登记
     */
    public static final String NYDSYQSCDJ = "1000901";

    /**
     * 林权首次登记
     */
    public static final String LQSCDJ = "1001201";

    /**
     * 抵押权首次登记
     */
    public static final String DYAQSCDJ = "1003701";

    /**
     * 地役权首次登记
     */
    public static final String DYIQSCDJ = "1002101";


    /**
     * 其他相关权利首次登记
     */
    public static final String QTXGQLSCDJ = "1009901";


    /**
     * 土地所有权转移登记
     */
    public static final String TDSYQZYDJ = "2000101";

    /**
     * 建设用地使用权、宅基地使用权转移登记
     */
    public static final String JSYDSYQZYDJ = "2000301";

    /**
     * 房地产权（项目内多幢房屋）转移登记
     */
    public static final String FDCQZYDJ1 = "2000401";

    /**
     * 房地产权（独幢、层、套、间、房屋）转移登记
     */
    public static final String FDCQZYDJ2 = "2000402";

    /**
     * 建筑物区分所有权业主共有部分转移登记
     */
    public static final String JZWQFSYQZYDJ = "2000403";

    /**
     * 海域(含无居民海岛)使用权转移登记
     */
    public static final String HYSYQZYDJ = "2001501";

    /**
     * 构（建）筑物所有权转移登记
     */
    public static final String GZWSYQZYDJ = "2001601";

    /**
     * 土地承包经营权、农用地使用权（非林地）转移登记
     */
    public static final String NYDSYQZYDJ = "2000901";

    /**
     * 林权转移登记
     */
    public static final String LQZYDJ = "2001201";


    /**
     * 抵押权转移登记
     */
    public static final String DYAQZYDJ = "2003701";

    /**
     * 地役权转移登记
     */
    public static final String DYIQZYDJ = "2002101";


    /**
     * 其他登记转移登记
     */
    public static final String QTDJZYDJ = "2009901";


    /**
     * 土地所有权变更登记
     */
    public static final String TDSYQBGDJ = "3000101";

    /**
     * 建设用地使用权、宅基地使用权变更登记
     */
    public static final String JSYDSYQBGDJ = "3000301";

    /**
     * 房地产权（项目内多幢房屋）变更登记
     */
    public static final String FDCQBGDJ1 = "3000401";

    /**
     * 房地产权（独幢、层、套、间、房屋）变更登记
     */
    public static final String FDCQBGDJ2 = "3000402";

    /**
     * 建筑物区分所有权业主共有部分变更登记
     */
    public static final String JZWQFSYQBGDJ = "3000403";

    /**
     * 海域(含无居民海岛)使用权变更登记
     */
    public static final String HYSYQBGDJ = "3001501";

    /**
     * 构（建）筑物所有权变更登记
     */
    public static final String GZWSYQBGDJ = "3001601";

    /**
     * 土地承包经营权、农用地使用权（非林地）变更登记
     */
    public static final String NYDSYQBGDJ = "3000901";

    /**
     * 林权变更登记
     */
    public static final String LQBGDJ = "3001201";


    /**
     * 抵押权变更登记
     */
    public static final String DYAQBGDJ = "3003701";


    /**
     * 地役权变更登记
     */
    public static final String DYIQBGDJ = "3002101";

    /**
     * 其他相关权利变更登记
     */
    public static final String QTXGQLBGDJ = "3009901";


    /**
     * 土地所有权更正登记
     */
    public static final String TDSYQGZDJ = "5000101";

    /**
     * 建设用地使用权、宅基地使用权更正登记
     */
    public static final String JSYDSYQGZDJ = "5000301";

    /**
     * 房地产权（项目内多幢房屋）更正登记
     */
    public static final String FDCQGZDJ1 = "5000401";

    /**
     * 房地产权（独幢、层、套、间、房屋）更正登记
     */
    public static final String FDCQGZDJ2 = "5000402";

    /**
     * 建筑物区分所有权业主共有部分更正登记
     */
    public static final String JZWQFSYQGZDJ = "5000403";

    /**
     * 海域(含无居民海岛)使用权更正登记
     */
    public static final String HYSYQGZDJ = "5001501";

    /**
     * 构（建）筑物所有权更正登记
     */
    public static final String GZWSYQGZDJ = "5001601";

    /**
     * 土地承包经营权、农用地使用权（非林地）更正登记
     */
    public static final String NYDSYQGZDJ = "5000901";

    /**
     * 林权更正登记
     */
    public static final String LQGZDJ = "5001201";

    /**
     * 抵押权更正登记
     */
    public static final String DYAQGZDJ = "5003701";


    /**
     * 地役权更正登记
     */
    public static final String DYIQGZDJ = "5002101";

    /**
     * 其他相关权利更正登记
     */
    public static final String QTXGQLGZDJ = "5009901";


    /**
     * //     * 注销登记
     * //
     */
    public static final String ZXDJ = "4000101";


    /**
     * 异议登记
     */
    public static final String YYDJ = "6000101";

    /**
     * 预告登记
     */
    public static final String YGDJ = "7000101";

    /**
     * 查封登记
     */
    public static final String CFDJ = "8000101";


    /**
     * 土地所有权换证登记
     */
    public static final String TDSYQHZDJ = "9000101";

    /**
     * 建设用地使用权、宅基地使用权换证登记
     */
    public static final String JSYDSYQHZDJ = "9000301";

    /**
     * 房地产权（项目内多幢房屋）换证登记
     */
    public static final String FDCQHZDJ1 = "9000401";


    /**
     * 房地产权（独幢、层、套、间、房屋）换证登记
     */
    public static final String FDCQHZDJ2 = "9000402";


    /**
     * 建筑物区分所有权业主共有部分换证登记
     */
    public static final String JZWQFSYQHZDJ = "9000403";


    /**
     * 海域（含无居民海岛）使用权换证登记
     */
    public static final String HYSYQHZDJ = "9001501";


    /**
     * 构（建）筑物所有权换证登记
     */
    public static final String GZWSYQHZDJ = "9001601";


    /**
     * 土地承包经营权、农用地的其他使用权（非林地）换证登记
     */
    public static final String NYDSYQHZDJ = "9000901";


    /**
     * 林权换证登记
     */
    public static final String LQHZDJ = "9001201";


    /**
     * 抵押权换证登记
     */
    public static final String DYAQHZDJ = "9003701";


    /**
     * 地役权换证登记
     */
    public static final String DYIQHZDJ = "9002101";


    /**
     * 其他登记换证登记
     */
    public static final String QTDJHZDJ = "9009901";



    /**
     * @author <a href="mailto:liujie@gtmap.cn">liujie</a>
     * @description 定期汇交（针对区县数据修改业务，省厅只更新数据）
     */
    public static final String DQHJ = "9999999";


    public static final Map<Object, String> REC_TYPE = Maps.newHashMap();

    public static final String XY = "610400";//咸阳
    public static final String YL = "610403";//杨凌示范区
    public static final String WN = "610500";//渭南
    public static final String HC = "610581";//韩城市


    public static final String BBXYBWBJ = "1";//报部响应报文标记

    public static final String BBSBXYBWBJ = "2";//市级平台报部失败响应报文标记

    public static final String BBSBREP_INDEXTYPE = "Bbsbrep";//市级平台报部失败响应报文表

    public static final String BBREP_INDEXTYPE = "Brep";//报部响应报文表

    public static final String BDCDYH = "bdcdyh";

    public static final String XH = "xh";

    public static final String ID = "id";

    public static final String SJGXSJ = "sjgxsj";

    /**
     * 权属状态字段
     */
    public static final String QSZT1 = "1";

    public static final String QSZT2 = "2";

    public static final String QSZT0 = "0";

    public static final String PUBLIC_KEY = "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDT9TsOfGqhv+3TxeU/jNwskOlXPF35Gffm4oGjUyC2ajplEiRZ+57x5wYXtqh1B3ulnSQY1PLO/Pw8i0jg1uwQoO0izGk31CrIloFpKAcve5JfGx0XBK1cffsGpFvjzL/gvRZHHvqGOH1BOyST8EcOrDnuT3Y3FtYbGdeDlH6AGQIDAQAB";

    public static final String DUPLICATE_CONTENT = "2021:业务报文重复提交，请检查流水号及数字签名！";

    public static final String DULICATE_SERVICE = "2024:业务校验重复！";

    public static final String SIGNATURE_FAIL = "2020:数字签名验证失败！";

    public static final String CLIENT_CHECK = "2022:客户端编码或名称或密码验证失败！";

    public static final String CG = "成功";

    public static final String SB = "失败";

    public static final String WSB = "未上报";

    public static final String EMPTY = "空";

    //宗地基本信息
    public static final String BA_ZDJBXX = "BA_ZDJBXX";

    //宗海基本信息
    public static final String BA_ZHJBXX = "BA_ZHJBXX";

    //自然幢信息
    public static final String BA_ZRZ = "BA_ZRZ";

    //构筑物信息
    public static final String BA_GZW = "BA_GZW";

    //面状定着物
    public static final String BA_MZDZW = "BA_MZDZW";

    //线状定着物
    public static final String BA_XZDZW = "BA_XZDZW";

    //点状定着物信息
    public static final String BA_DZDZW = "BA_DZDZW";

    //户信息
    public static final String BA_H = "BA_H";

    //土地所有权
    public static final String BA_TDSYQ = "BA_TDSYQ";

    //建设用地、宅基地使用权
    public static final String BA_JSYDSYQ = "BA_JSYDSYQ";

    //房地产权_项目内多幢房屋信息
    public static final String BA_FDCQ1 = "BA_FDCQ1";

    //房地产权_项目内多幢房屋）项目属性
    public static final String BA_FDCQXM = "BA_FDCQXM";

    //房地产权_独幢、层、套、间房屋信息
    public static final String BA_FDCQ2 = "BA_FDCQ2";

    //建筑物区分所有权业主共有部分信息
    public static final String BA_FDCQ3 = "BA_FDCQ3";

    //海域（含无居民海岛）使用权
    public static final String BA_HYSYQ = "BA_HYSYQ";

    //构（建）筑物所有权
    public static final String BA_GJZWSYQ = "BA_GJZWSYQ";

    //农用地使用权（非林地）
    public static final String BA_NYDSYQ = "BA_NYDSYQ";

    //林权
    public static final String BA_LQ = "BA_LQ";

    //其他相关权利
    public static final String BA_QTXGQL = "BA_QTXGQL";

    //抵押权
    public static final String BA_DYAQ = "BA_DYAQ";

    //预告登记信息
    public static final String BA_YGDJ = "BA_YGDJ";

    //异议登记信息
    public static final String BA_YYDJ = "BA_YYDJ";

    //查封登记信息
    public static final String BA_CFDJ = "BA_CFDJ";

    //权利人
    public static final String BA_QLR = "BA_QLR";

    //注销登记
    public static final String BA_ZXDJ = "BA_ZXDJ";

    //权利人（单位）和权利关系
    public static final String BA_QLRGX = "BA_QLRGX";

    //宗地空间属性
    public static final String BA_ZDK103 = "BA_ZDK103";

    //宗海空间属性
    public static final String BA_ZHK105 = "BA_ZHK105";

    //申请人
    public static final String BA_SQR = "BA_SQR";

    //地役权
    public static final String BA_DYIQ = "BA_DYIQ";

    //宗地变化情况
    public static final String BA_ZDBHQK = "BA_ZDBHQK";

    //宗海变化情况
    public static final String BA_ZHBHQK = "BA_ZHBHQK";

    //用海状况
    public static final String BA_YHZK = "BA_YHZK";

    //用海、用岛坐标
    public static final String BA_YHYDZB = "BA_YHYDZB";


    //登记受理申请信息
    public static final String BA_SLSQ = "BA_SLSQ";

    //登记收件信息
    public static final String BA_SJ = "BA_SJ";

    //登记收费信息
    public static final String BA_SF = "BA_SF";

    //登记审核信息
    public static final String BA_SH = "BA_SH";

    //登记缮证信息
    public static final String BA_SZ = "BA_SZ";

    //登记发证信息
    public static final String BA_FZ = "BA_FZ";

    //登记归档信息
    public static final String BA_GD = "BA_GD";

    //逻辑幢信息
    public static final String BA_LJZ = "BA_LJZ";

    //层信息
    public static final String BA_C = "BA_C";


    public static final String SYQMJ = "syqmj";
    public static final String JZMJ = "jzmj";
    public static final String QLLX = "qllx";
    public static final String QLRMC = "qlrmc";
    public static final String ZJH = "zjh";

    public static final String BDCQZH = "bdcqzh";
    public static final String BDCDJZMH = "bdcdjzmh";
    public static final String DJSJ = "djsj";
    public static final String SLSJ = "slsj";
    public static final String YT = "yt";

    public static final String GHYT = "ghyt";
    public static final String YWH = "ywh";
    public static final String QXDM = "qxdm";

    public static final String DJLX = "djlx";
    public static final String QLRLX = "qlrlx";
    public static final String GYFS = "gyfs";
    public static final String COUNT = "count";

    public static final String FDCJYJG = "fdcjyjg";
    public static final String BDBZZQSE = "bdbzzqse";

    public static final String DUPLICATE_CONTENT_CHECK = "200102";

    public static final String SUCCESS = "数据验证成功";

    public static final String SUCCESS_CODE = "0000";

    public static final String ERROR_CODE2 = "2022";

    public static final String KHDJYCW = "客户端校验错误！";

    public static final String XXCGCL = "消息成功处理";

    public static final String XXBSCG = "消息报省成功";

    public static final String XXBSSB = "消息报省失败";

    public static final String JSQMCW = "接受签名错误";

    public static final String SJJYCW = "数据校验错误";

    public static final String SJRKSB = "数据入库失败";

    public static final String CGRK = "成功入库";

    public static final String CODE_2020 = "2020";

    public static final String CODE_1000 = "1000";

    public static final String CODE_2 = "2";

    public static final String CODE_1 = "1";

    public static final String CODE_0= "0";

    public static final String CODE_0001 = "0001";

    public static final String CODE_T= "true";

    public static final String CODE_F= "false";



    public static final Map<String, Object> PARAMS = Maps.newHashMap();

    //xsd校验失败响应编码
    public static final String XYBM_2023 = "2023";

    static {
        REC_TYPE.put(TDSYQZYDJ, "BaTdsyq");
        REC_TYPE.put(JSYDSYQZYDJ, "BaJsydsyq");
        REC_TYPE.put(FDCQZYDJ1, "BaFdcq1");
        REC_TYPE.put(FDCQZYDJ2, "BaFdcq2");
        REC_TYPE.put(JZWQFSYQZYDJ, "BaFdcq3");
        REC_TYPE.put(HYSYQZYDJ, "BaHysyq");
        REC_TYPE.put(GZWSYQZYDJ, "BaGjzwsyq");
        REC_TYPE.put(NYDSYQZYDJ, "BaNydsyq");
        REC_TYPE.put(LQZYDJ, "BaLq");

        REC_TYPE.put(TDSYQBGDJ, "BaTdsyq");
        REC_TYPE.put(JSYDSYQBGDJ, "BaJsydsyq");
        REC_TYPE.put(FDCQBGDJ1, "BaFdcq1");
        REC_TYPE.put(FDCQBGDJ2, "BaFdcq2");
        REC_TYPE.put(JZWQFSYQBGDJ, "BaFdcq3");
        REC_TYPE.put(HYSYQBGDJ, "BaHysyq");
        REC_TYPE.put(GZWSYQBGDJ, "BaGjzwsyq");
        REC_TYPE.put(NYDSYQBGDJ, "BaNydsyq");
        REC_TYPE.put(LQBGDJ, "BaLq");

        REC_TYPE.put(TDSYQGZDJ, "BaTdsyq");
        REC_TYPE.put(JSYDSYQGZDJ, "BaJsydsyq");
        REC_TYPE.put(FDCQGZDJ1, "BaFdcq1");
        REC_TYPE.put(FDCQGZDJ2, "BaFdcq2");
        REC_TYPE.put(JZWQFSYQGZDJ, "BaFdcq3");
        REC_TYPE.put(HYSYQGZDJ, "BaHysyq");
        REC_TYPE.put(GZWSYQGZDJ, "BaGjzwsyq");
        REC_TYPE.put(NYDSYQGZDJ, "BaNydsyq");
        REC_TYPE.put(LQGZDJ, "BaLq");

        List<String> list = Lists.newArrayList();
        list.add(BA_ZDJBXX);
        list.add(BA_ZHJBXX);
        list.add(BA_ZRZ);
        list.add(BA_GZW);
        list.add(BA_MZDZW);
        list.add(BA_XZDZW);
        list.add(BA_DZDZW);
        list.add(BA_H);
        list.add(BA_TDSYQ);
        list.add(BA_JSYDSYQ);
        list.add(BA_FDCQ1);
        list.add(BA_FDCQXM);
        list.add(BA_FDCQ2);
        list.add(BA_FDCQ3);
        list.add(BA_HYSYQ);
        list.add(BA_GJZWSYQ);
        list.add(BA_NYDSYQ);
        list.add(BA_LQ);
        list.add(BA_QTXGQL);
        list.add(BA_DYAQ);
        list.add(BA_YGDJ);
        list.add(BA_YYDJ);
        list.add(BA_CFDJ);
        list.add(BA_QLR);
        list.add(BA_ZXDJ);
        list.add(BA_QLRGX);
        list.add(BA_ZDK103);
        list.add(BA_ZHK105);
        PARAMS.put(BDCDYH, list);

        list = Lists.newArrayList();
        list.add(BA_ZDJBXX);
        list.add(BA_JSYDSYQ);
        PARAMS.put(SYQMJ, list);

        list = Lists.newArrayList();
        list.add(BA_FDCQ2);
        PARAMS.put(JZMJ, list);


        list = Lists.newArrayList();
        list.add(BA_ZDJBXX);
        list.add(BA_TDSYQ);
        list.add(BA_JSYDSYQ);
        list.add(BA_FDCQ1);
        list.add(BA_FDCQXM);
        list.add(BA_FDCQ2);
        list.add(BA_FDCQ3);
        list.add(BA_HYSYQ);
        list.add(BA_GJZWSYQ);
        list.add(BA_NYDSYQ);
        list.add(BA_LQ);
        list.add(BA_QTXGQL);
        PARAMS.put(QLLX, list);

        list = Lists.newArrayList();
        list.add(BA_QLR);
        list.add(BA_SQR);
        PARAMS.put(QLRMC, list);

        list = Lists.newArrayList();
        list.add(BA_QLR);
        PARAMS.put(ZJH, list);


        list = Lists.newArrayList();
        list.add(BA_TDSYQ);
        list.add(BA_JSYDSYQ);
        list.add(BA_FDCQ1);
        list.add(BA_FDCQ2);
        list.add(BA_HYSYQ);
        list.add(BA_GJZWSYQ);
        list.add(BA_NYDSYQ);
        list.add(BA_LQ);
        list.add(BA_QTXGQL);
        list.add(BA_ZXDJ);
        list.add(BA_QLRGX);
        PARAMS.put(BDCQZH, list);

        list = Lists.newArrayList();
        list.add(BA_DYIQ);
        list.add(BA_DYAQ);
        list.add(BA_YGDJ);
        list.add(BA_YYDJ);
        PARAMS.put(BDCDJZMH, list);


        list = Lists.newArrayList();
        list.add(BA_SLSQ);
        PARAMS.put(SLSJ, list);

        list = Lists.newArrayList();
        list.add(BA_ZDJBXX);
        list.add(BA_ZDBHQK);
        list.add(BA_ZHJBXX);
        list.add(BA_ZHBHQK);
        list.add(BA_TDSYQ);
        list.add(BA_JSYDSYQ);
        list.add(BA_FDCQ1);
        list.add(BA_FDCQ2);
        list.add(BA_FDCQ3);
        list.add(BA_HYSYQ);
        list.add(BA_GJZWSYQ);
        list.add(BA_NYDSYQ);
        list.add(BA_LQ);
        list.add(BA_QTXGQL);
        list.add(BA_DYIQ);
        list.add(BA_DYAQ);
        list.add(BA_YGDJ);
        list.add(BA_YYDJ);
        list.add(BA_CFDJ);
        list.add(BA_ZXDJ);
        list.add(BA_YYDJ);
        list.add(BA_CFDJ);
        PARAMS.put(DJSJ, list);

        list = Lists.newArrayList();
        list.add(BA_ZDJBXX);
        PARAMS.put(YT, list);

        list = Lists.newArrayList();
        list.add(BA_FDCQ2);
        PARAMS.put(GHYT, list);

        list = Lists.newArrayList();
        list.add(BA_CFDJ);
        list.add(BA_TDSYQ);
        list.add(BA_JSYDSYQ);
        list.add(BA_FDCQ1);
        list.add(BA_FDCQ2);
        list.add(BA_FDCQ3);
        list.add(BA_HYSYQ);
        list.add(BA_GJZWSYQ);
        list.add(BA_NYDSYQ);
        list.add(BA_QTXGQL);
        list.add(BA_DYIQ);
        list.add(BA_LQ);
        list.add(BA_YYDJ);
        list.add(BA_ZXDJ);
        PARAMS.put(YWH, list);


        list = Lists.newArrayList();
        list.add(BA_ZDJBXX);
        list.add(BA_ZDBHQK);
        list.add(BA_ZHJBXX);
        list.add(BA_YHZK);
        list.add(BA_YHYDZB);
        list.add(BA_ZHBHQK);
        list.add(BA_ZRZ);
        list.add(BA_MZDZW);
        list.add(BA_XZDZW);
        list.add(BA_DZDZW);
        list.add(BA_LJZ);
        list.add(BA_C);
        list.add(BA_H);
        list.add(BA_TDSYQ);
        list.add(BA_JSYDSYQ);
        list.add(BA_FDCQ1);
        list.add(BA_FDCQXM);
        list.add(BA_FDCQ2);
        list.add(BA_FDCQ3);
        list.add(BA_HYSYQ);
        list.add(BA_GJZWSYQ);
        list.add(BA_NYDSYQ);
        list.add(BA_LQ);
        list.add(BA_QTXGQL);
        list.add(BA_DYAQ);
        list.add(BA_YGDJ);
        list.add(BA_YYDJ);
        list.add(BA_CFDJ);
        list.add(BA_QLR);
        list.add(BA_SQR);
        list.add(BA_SLSQ);
        list.add(BA_SJ);
        list.add(BA_SF);
        list.add(BA_SH);
        list.add(BA_SZ);
        list.add(BA_FZ);
        list.add(BA_GD);
        list.add(BA_ZXDJ);
        list.add(BA_QLRGX);
        PARAMS.put(QXDM, list);


        list = Lists.newArrayList();
        list.add(BA_TDSYQ);
        list.add(BA_JSYDSYQ);
        list.add(BA_FDCQ1);
        list.add(BA_FDCQ2);
        list.add(BA_HYSYQ);
        list.add(BA_GJZWSYQ);
        list.add(BA_NYDSYQ);
        list.add(BA_LQ);
        list.add(BA_QTXGQL);
        list.add(BA_DYIQ);
        list.add(BA_DYAQ);
        list.add(BA_YGDJ);
        PARAMS.put(DJLX, list);

        list = Lists.newArrayList();
        list.add(BA_QLR);
        PARAMS.put(QLRLX, list);

        list = Lists.newArrayList();
        list.add(BA_QLR);
        list.add(BA_QLRGX);
        PARAMS.put(GYFS, list);


        list = Lists.newArrayList();
        list.add(BA_FDCQ1);
        list.add(BA_FDCQ2);
        PARAMS.put(FDCJYJG, list);

        list = Lists.newArrayList();
        list.add(BA_DYAQ);
        PARAMS.put(BDBZZQSE, list);
    }

    public static String getMsg(Object code) {
        return REC_TYPE.get(code);
    }

}
