package cn.gtmap.realestate.supervise.server.common.impl.check;

import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.realestate.supervise.aes.AESUtil;
import cn.gtmap.realestate.supervise.model.FileMessage;
import cn.gtmap.realestate.supervise.model.MessageClient;
import cn.gtmap.realestate.supervise.server.common.impl.AbstractCheckMessage;
import cn.gtmap.realestate.supervise.server.common.impl.CheckResultManage;
import cn.gtmap.realestate.supervise.server.config.Constant;
import cn.gtmap.realestate.supervise.server.entity.ClientInfo;
import cn.gtmap.realestate.supervise.server.service.ClientInfoService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
 * @version 1.0, 2017/7/4
 * @description 客户端校验
 */
@Service
public class UserInfoCheck extends AbstractCheckMessage {


    private static final Logger LOGGER = LoggerFactory.getLogger(UserInfoCheck.class);

    @Autowired
    EntityMapper entityMapper;

    @Autowired
    CheckResultManage checkResultManage;

    @Autowired
    ClientInfoService clientInfoService;

    @Autowired
    AESUtil  aesUtil;
    /**
     * 初始化该验证是否对后面的验证有影响，如果该验证不通过不进行下面的验证设置为true比如用户验证
     */
    public UserInfoCheck() {
        super(false, "100101");
    }

    /**
     * 验证用户是否正确
     * @param message 待验证的用户信息
     * @return 没办法为了统一返回了个空的东西想不返回的
     */
    @Override
    public CheckResultManage checkMessage(MessageClient message) {
        if(!checkUserInfo(message)) {
            LOGGER.info("客户端验证失败！");
            super.setMessageError(true);
            List<FileMessage> fileMessages = message.getMessageContents();
            checkResultManage.putErrorCheckResult(fileMessages.get(0),Constant.CLIENT_CHECK);
        }
        return checkResultManage;
    }

    /**
     * 校验接入点信息
     * @param message
     * @return
     */
    private boolean checkUserInfo(MessageClient message) {

        Map<String, Object> param = new HashMap<>();
        param.put("qxdm", message.getForm());
        param.put("qxmc", message.getServerName());
        param.put("khdmm", aesUtil.encryptXml(message.getPassword()));
        List<ClientInfo> clientInfos = clientInfoService.getUserInfos(param);
        return clientInfos != null;
    }
}
