package cn.gtmap.realestate.supervise.server.common.impl.check;

import cn.gtmap.realestate.supervise.model.FileMessage;
import cn.gtmap.realestate.supervise.model.MessageClient;
import cn.gtmap.realestate.supervise.server.common.impl.AbstractCheckMessage;
import cn.gtmap.realestate.supervise.server.common.impl.CheckResultManage;
import cn.gtmap.realestate.supervise.server.common.impl.ObjectServiceImpl;
import cn.gtmap.realestate.supervise.server.utils.XmlUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author <a href="mailto:gaofeng@gtmap.cn">gaofeng</a>
 * @version 1.0, 2017/7/3
 * @description 图形坐标参考检查规则
 */
@Service
public class TuXingZuoBiaoCheck extends AbstractCheckMessage {
    /**
     * 初始化该验证是否对后面的验证有影响，如果该验证不通过不进行下面的验证设置为true比如用户验证
     */
    public TuXingZuoBiaoCheck() {
        super(true, "400101");
    }


    private static final Logger LOGGER = LoggerFactory.getLogger(TuXingZuoBiaoCheck.class);

    @Autowired
    ObjectServiceImpl objectService;

    @Autowired
    CheckResultManage checkResultManage;

    @Override
    public CheckResultManage checkMessage(MessageClient messages) {

        List<FileMessage> fileMessages = messages.getMessageContents();
        for (FileMessage fileMessage : fileMessages) {

            String recType = fileMessage.getRectype();

            //根据业务类型判断 首次登记和更正登记
            if (recType.startsWith("100") || recType.startsWith("200")) {

                String content = XmlUtil.getContent(fileMessage);
                String fileName = fileMessage.getFileName();
                String resStr = "";
                resStr = objectService.getZbInfos(content, fileName);
                if (null != resStr && resStr.length() > 0) {
                    checkResultManage.putErrorCheckResult(fileMessage, "2025:" + resStr);
                }
            }
        }


        return checkResultManage;
    }
}
