package cn.gtmap.realestate.supervise.server.common.impl.check;

import cn.gtmap.realestate.supervise.model.FileMessage;
import cn.gtmap.realestate.supervise.model.MessageClient;
import cn.gtmap.realestate.supervise.rsa.RSASignature;
import cn.gtmap.realestate.supervise.server.common.impl.AbstractCheckMessage;
import cn.gtmap.realestate.supervise.server.common.impl.CheckResultManage;
import cn.gtmap.realestate.supervise.server.config.Constant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
 * @version 1.0, 2017/7/3
 * @description 签名校验
 */
@Service
public class SignatureCheck extends AbstractCheckMessage {
    /**
     * 初始化该验证是否对后面的验证有影响，如果该验证不通过不进行下面的验证设置为true比如用户验证
     */

    private static final Logger LOGGER = LoggerFactory.getLogger(SignatureCheck.class);

    @Autowired
    CheckResultManage checkResultManage;


    public SignatureCheck() {
        super(true, "200101");
    }

    /**
     * 验证用户的xml文档和业务规范xsd文件是否一致
     *
     * @param messages 需要验证的文件
     * @return 返回验证结果管理器
     */
    @Override
    public CheckResultManage checkMessage(MessageClient messages) {
        List<FileMessage> fileMessages = messages.getMessageContents();
        for (FileMessage fileMessage : fileMessages) {
            boolean check;
            try {
                check = RSASignature.CheckXmlByPulKey(new String(fileMessage.getContent(), "UTF-8"), Constant.PUBLIC_KEY);
                if (!check) {
                    checkResultManage.putErrorCheckResult(fileMessage, Constant.SIGNATURE_FAIL);
                }
            } catch (Exception e) {
                checkResultManage.putErrorCheckResult(fileMessage, Constant.SIGNATURE_FAIL);
                super.setServiceError(false);
                LOGGER.error("数字签名校验异常!:{}", e);
            }
            return checkResultManage;
        }
        return checkResultManage;
    }
}
