package cn.gtmap.realestate.supervise.server.common.impl.check;

import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.realestate.supervise.entity.BaSlsq;
import cn.gtmap.realestate.supervise.model.FileMessage;
import cn.gtmap.realestate.supervise.model.MessageClient;
import cn.gtmap.realestate.supervise.server.common.impl.AbstractCheckMessage;
import cn.gtmap.realestate.supervise.server.common.impl.CheckResultManage;
import cn.gtmap.realestate.supervise.server.common.impl.ObjectServiceImpl;
import cn.gtmap.realestate.supervise.server.config.Constant;
import cn.gtmap.realestate.supervise.server.utils.ExampleUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:gaofeng@gtmap.cn">gaofeng</a>
 * @version 1.0, 2017/7/3
 * @description 业务重复检查
 */
@Service
public class DuplicateServiceCheck extends AbstractCheckMessage {
    /**
     * 初始化该验证是否对后面的验证有影响，如果该验证不通过不进行下面的验证设置为true比如用户验证
     */
    public DuplicateServiceCheck() {
        super(true, "300101");
    }

    @Autowired
    CheckResultManage checkResultManage;


    @Autowired
    ObjectServiceImpl objectService;


    @Autowired
    EntityMapper entityMapper;

    /**
     * 验证用户的xml文档和业务规范xsd文件是否一致
     *
     * @param messages 需要验证的文件
     * @return 返回验证结果管理器
     */
    @Override
    public CheckResultManage checkMessage(MessageClient messages) {
        List<FileMessage> fileMessages = messages.getMessageContents();
        Map<String, Object> param = new HashMap<>();
        for (FileMessage fileMessage : fileMessages) {
            String ywh = fileMessage.getRecFlowID();
            String qxdm = fileMessage.getAreaCode();
            String ywhStr = qxdm + "_" + ywh;
            param.put("ywh", ywhStr);
            ExampleUtil example = new ExampleUtil(BaSlsq.class, param);
            List<BaSlsq> baSlsqList = entityMapper.selectByExample(example);
            if (null != baSlsqList && !baSlsqList.isEmpty()) {
                checkResultManage.putErrorCheckResult(fileMessage, Constant.DULICATE_SERVICE);
            }
        }
        return checkResultManage;
    }


}
