package cn.gtmap.realestate.supervise.server.common.impl.check;

import cn.gtmap.realestate.supervise.model.FileMessage;
import cn.gtmap.realestate.supervise.model.MessageClient;
import cn.gtmap.realestate.supervise.server.common.impl.AbstractCheckMessage;
import cn.gtmap.realestate.supervise.server.common.impl.CheckResultManage;
import cn.gtmap.realestate.supervise.server.config.Constant;
import cn.gtmap.realestate.supervise.server.dao.SignDao;
import cn.gtmap.realestate.supervise.server.dao.mapper.BaRzjlMapper;
import cn.gtmap.realestate.supervise.server.entity.Rzjl;
import cn.gtmap.realestate.supervise.server.entity.Sign;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author <a href="mailto:gaofeng@gtmap.cn">gaofeng</a>
 * @version 1.0, 2017/7/3
 * @description 报文重复校验
 */
@Service
public class DuplicateContentCheck extends AbstractCheckMessage {
    /**
     * 初始化该验证是否对后面的验证有影响，如果该验证不通过不进行下面的验证设置为true比如用户验证
     */
    public DuplicateContentCheck() {
        super(true, "200102");
    }

    @Autowired
    CheckResultManage checkResultManage;


    @Autowired
    SignDao signDao;

    @Autowired
    BaRzjlMapper baRzjlMapper;

    /**
     * 验证用户的xml文档和业务规范xsd文件是否一致
     *
     * @param messages 需要验证的文件
     * @return 返回验证结果管理器
     */
    @Override
    public CheckResultManage checkMessage(MessageClient messages) {
        List<FileMessage> fileMessages = messages.getMessageContents();
        for (FileMessage fileMessage : fileMessages) {
            boolean flag = signDao.findBySign(fileMessage.getSign());//数字签名校验
            String fileName = fileMessage.getFileName();
            List<Rzjl> rzjls = baRzjlMapper.getRzjlByFileName(fileName);
            boolean bizMsgIdFlag = CollectionUtils.isNotEmpty(rzjls)?true:false;
            if (flag || bizMsgIdFlag) {
                checkResultManage.putErrorCheckResult(fileMessage, Constant.DUPLICATE_CONTENT);
            } else {
                Sign sign = new Sign();
                sign.setSign(fileMessage.getSign());
                signDao.insertSign(sign);
            }
        }
        return checkResultManage;
    }
}
