package cn.gtmap.realestate.supervise.server.common.impl.check;

import cn.gtmap.realestate.supervise.model.MessageClient;
import cn.gtmap.realestate.supervise.server.common.impl.AbstractCheckMessage;
import cn.gtmap.realestate.supervise.server.common.impl.CheckResultManage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

/**
 * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
 * @version 1.0, 2017/7/3
 * @description 不动产单元类型检测
 */
@Service
public class BdcDyLxCheck extends AbstractCheckMessage {

    private static final Logger LOGGER = LoggerFactory.getLogger(BdcDyLxCheck.class);
    /**
     * 初始化该验证是否对后面的验证有影响，如果该验证不通过不进行下面的验证设置为true比如用户验证
     *
     */
    public BdcDyLxCheck() {
        super(true, "300401");
    }

    @Override
    public CheckResultManage checkMessage(MessageClient messages) {
        LOGGER.info("进行不动产抵押类型检查");
        return null;
    }

}
