package cn.gtmap.realestate.supervise.server.common.impl;

import cn.gtmap.estateplat.core.ex.AppException;
import cn.gtmap.realestate.supervise.entity.UserAuthDTO;
import cn.gtmap.realestate.supervise.server.common.SystemLogService;
import cn.gtmap.realestate.supervise.server.entity.Log;
import cn.gtmap.realestate.supervise.server.service.LogService;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.gtis.common.util.UUIDGenerator;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * @author <a href="mailto:gaofeng@gtmap.cn">gaofeng</a>
 * @version 1.0，2017/5/27
 * @description 切面类
 */
@Aspect
@Component
public class SystemLogAspect {

    //注入Service用于把日志保存数据库
    @Resource
    private LogService logService;

    //本地异常日志记录对象
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemLogAspect.class);

    /**
     * Service层切入点
     *
     * @throws UnsupportedOperationException
     */
    @Pointcut("@annotation(cn.gtmap.realestate.supervise.server.common.SystemLogService)")
    public void serviceAspect() throws UnsupportedOperationException {
    }

    /**
     * 通知 用于拦截service层记录异常日志
     *
     * @param joinPoint
     */
    @Before("serviceAspect()")
    public void doBefore(JoinPoint joinPoint) {
        HttpServletRequest request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
        //获取请求ip
        String ip = request.getRemoteAddr();
        String user = "";
        try {
            //获取用户请求方法的参数并序列化为JSON格式字符串
            String params = "";
            Map<String, String> resMap = getServiceMthodDescription(joinPoint);
            String czlx = resMap.get("czlx");
            String desc = resMap.get("des");
            if (joinPoint.getArgs() != null && joinPoint.getArgs().length > 0) {
                for (int i = 0; i < joinPoint.getArgs().length; i++) {
                    Object objects = joinPoint.getArgs()[i];
                    if (null != objects && !objects.toString().isEmpty()) {
                        String jsonString = JSON.toJSONString(objects.toString());
                        if (jsonString.contains("qxCode")) {
                            String str1 = jsonString.replace("qxCode", "区县代码");
                            String str2 = str1.replace("jssj", "结束时间");
                            String str3 = str2.replace("kssj", "开始时间");
                            jsonString = str3;
                        }
                        if (jsonString.contains("dsCode")) {
                            String str1 = jsonString.replace("dsCode", "地市代码");
                            String str2 = str1.replace("jssj", "结束时间");
                            String str3 = str2.replace("kssj", "开始时间");
                            String str4 = str3.replace("qxCode", "区县代码");
                            jsonString = str4;
                        }
                        if ("入库数据删除".equals(czlx)) {
                            String str2 = jsonString.replace("bwlj", "报文路径");
                            String str3 = str2.replace("ywbm", "业务编码");
                            String str4 = str3.replace("bdcdyh", "不动产单元号");
                            String str5 = str4.replace("fileName", "文件名称");
                            String str6 = str5.replace("sbcode", "地区编码");
                            jsonString = str6;
                        }

                        if ("删除接入点关联区划信息".equals(desc) && !(objects instanceof UserAuthDTO)) {
                            Map<String, String> temp = (Map<String, String>) objects;
                            temp.remove("id");
                            jsonString = JSON.toJSONString(temp.toString());
                            String str1 = jsonString.replace("qhdm", "区划代码");
                            String str2 = str1.replace("jrddm", "接入点代码");
                            jsonString = str2;
                        }
                        if (objects instanceof UserAuthDTO) {
                            user = ((UserAuthDTO) objects).getUsername();
                        } else if (null != jsonString && !jsonString.isEmpty() && !jsonString.contains("WebStatFilter")) {
                            params += jsonString + ";";
                        }
                    }
                }
            }
            Log log = new Log();
            log.setCzlx(czlx);
            log.setCznr(resMap.get("des") + "\n" + "参数为:" + params);
            log.setCzrq(new Date());
            log.setId(UUIDGenerator.generate18());
            log.setIp(ip);
            log.setYhmc(user);
            logService.insertBalog(log);

        } catch (Exception ex) {
            LOGGER.error("SystemLogAspect.Exception  in !{}", ex.getMessage());
            throw new AppException(ex, 2017);
        }

    }


    /**
     * 获取注解中对方法的描述信息 用于service层注解
     *
     * @param joinPoint 切点
     * @return 方法描述
     * @throws Exception
     */
    public static Map<String, String> getServiceMthodDescription(JoinPoint joinPoint) throws ClassNotFoundException {
        String targetName = joinPoint.getTarget().getClass().getName();
        String methodName = joinPoint.getSignature().getName();
        Object[] arguments = joinPoint.getArgs();
        Class targetClass = Class.forName(targetName);
        Method[] methods = targetClass.getMethods();
        String description;
        String czlx;
        Map<String, String> resMap = new HashMap<>();
        for (Method method : methods) {
            if (method.getName().equals(methodName)) {
                Class[] clazzs = method.getParameterTypes();
                if (clazzs.length == arguments.length) {
                    description = method.getAnnotation(SystemLogService.class).description();
                    czlx = method.getAnnotation(SystemLogService.class).czlx();
                    resMap.put("des", description);
                    resMap.put("czlx", czlx);
                    break;
                }
            }
        }
        return resMap;
    }
}