package cn.gtmap.realestate.supervise.server.common.impl;

import cn.gtmap.estateplat.core.ex.AppException;
import cn.gtmap.realestate.supervise.aes.AESUtil;
import cn.gtmap.realestate.supervise.model.MessageClient;
import cn.gtmap.realestate.supervise.server.common.ServerRecMessageService;
import cn.gtmap.realestate.supervise.server.service.HeartbeatService;
import cn.gtmap.realestate.supervise.server.utils.BeanUtils;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import com.gtis.common.util.UUIDGenerator;
import com.rabbitmq.client.Channel;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.DocumentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;


/**
 * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
 * @version 1.0, 2017/3/23
 * @description 中心端接收客户端消息服务
 */
@Service
@Component
public class ServerRecMessageServiceImpl implements ServerRecMessageService {

    private static final Logger LOGGER = LoggerFactory.getLogger(ServerRecMessageServiceImpl.class);


    MessageClient dataMessage = null;

    @Autowired
    AESUtil aesUtil;

    @Autowired
    HeartbeatService heartbeatService;

    /**
     * @param message 获得的消息
     * @param channel 监听的消息信道
     * @throws IOException
     * @throws DocumentException
     * @throws ClassNotFoundException
     * @description 服务端消息监听并处理
     * 所有异常抛出需要进一步确认如何处理
     */
    @Override
    public void onMessage(Message message, Channel channel) throws IOException {
        byte[] body = message.getBody();
        String srcMessage = new String(body, "UTF-8");
        //中心端解密报文
        String tempMessage = aesUtil.decryptXML(srcMessage);
        if (StringUtils.isNotBlank(srcMessage)) {
            try {
                dataMessage = JSON.parseObject(tempMessage, MessageClient.class);
            } catch (Exception e) {
                LOGGER.error("ServerRecMessageServiceImpl.Exception!{}", e);
                return;
            }

            if (null != dataMessage.getMessageContents()) {
                try {
                    LOGGER.info("服务端消息ServerName:{},消息fileName:{}", dataMessage.getServerName(), dataMessage.getFileMessages().get(0).getFileName());
                    DataInsertDbService dataInsertDbService = BeanUtils.getDataInsertDbService();
                    dataInsertDbService.setMessageClient(dataMessage);
                    dataInsertDbService.dataHandle();
//                    //服务异步、业务逻辑处理
                    dataInsertDbService.serviceHandle();
                   //入库操作
                    LOGGER.info("心跳监测信息入库-------");
                    Map<String,Object> param = new HashMap<>();
                    param.put("id", UUIDGenerator.generate18());
                    param.put("jrmc",getDataMessage().getServerName());//接入名称
                    param.put("jrsj",dataMessage.getSendTime());  //时间
                    heartbeatService.SaveHeartJump(param);

                } catch (Exception e) {
                    LOGGER.error("程序验证模块出现严重错误请查证!{}", e);
                    throw new AppException(e, 2013);
                } finally {
                    basicAck(message, channel);
                }
                LOGGER.info("消息返回!");
            } else {
                Map<String, Object> param =Maps.newHashMap();
                param.put("khdbm", dataMessage.getForm());
                heartbeatService.updateBaJrdStatus(param);
                basicAck(message, channel);
            }
        }
    }


    /**
     * 将处理结果发回到客户端供客户端解析处理
     * 如果异常需要记录异常的编号
     */
    private void basicAck(Message message, Channel channel) {
        try {
            channel.basicAck(message.getMessageProperties().getDeliveryTag(), true); //确认消息成功消费
        } catch (IOException e) {
            LOGGER.error("basicAck.IOException in!{}", e);
            throw new AppException(e, 2014);
        }
    }

    public MessageClient getDataMessage() {
        return dataMessage;
    }

    public void setDataMessage(MessageClient dataMessage) {
        this.dataMessage = dataMessage;
    }
}
