package cn.gtmap.realestate.supervise.server.common.impl;

import cn.gtmap.estateplat.core.ex.AppException;
import cn.gtmap.realestate.supervise.entity.*;
import cn.gtmap.realestate.supervise.server.common.ObjectService;
import cn.gtmap.realestate.supervise.server.config.Constant;
import cn.gtmap.realestate.supervise.server.utils.XmlUtil;
import cn.gtmap.realestate.supervise.utils.FileUtil;
import cn.gtmap.realestate.supervise.utils.JaxbUtil;
import com.gtis.config.AppConfig;
import org.dom4j.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
 * @version 1.0, 2017/3/24
 * @description 将接收的到文本消息转换为实例对象
 * <ZTT_GY_QLR BDCDYH="321102017005GB00036W00000000" BDCQZH="苏(2016)镇江市不动产权第0026147号"
 * GJ="142" GYFS="0" QLRLX="2" QLRMC="镇江恒伟供应链管理股份有限公司" QXDM="321102" QZYSXLH="32001819386"
 * SFCZR="1" SXH="1" YB="212001" YSDM="6003000000" ZJH="91321100711514315C" ZJZL="7"/>
 * 实体为BaQlr 通过工具转换需要如下形式
 * <baQlr bdcdyh="321102017005GB00036W00000000" bdcqzh="苏(2016)镇江市不动产权第0026147号"
 * gj="142" gyfc="0" qlrlx="2" qlrmc="镇江恒伟供应链管理股份有限公司" qxdm="321102" qzysxlh="32001819386"
 * sfczr="1" sxh="1" yb="212001" ysdm="6003000000" zjh="91321100711514315C" zjzl="7"/>
 */
public class ObjectServiceImpl implements ObjectService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ObjectServiceImpl.class);

    String qxdm = AppConfig.getProperty("supersive.server.qhdm");//需要转换的区划代码

    /**
     * @param content 需要转换的字符串
     * @return xml中对应的实体
     * @throws DocumentException
     * @throws ClassNotFoundException
     */
    public List<Object> getObject(String content, String recType, String fileName, String areaCode, String bdcdyh) {
        List<Object> objects = new ArrayList<>();
        Map<String, List<String>> datas = ChangeXmlFormat.getParamValueByElement(content, "Data", fileName);
        String ywh = "";
        String bz = "";
        BaSlsq baSlsq = new BaSlsq();
        for (Map.Entry<String, List<String>> entry : datas.entrySet()) {
            List<String> allDatas = entry.getValue();
            for (String str : allDatas) {
                try {
                    Class attrObjClass = Class.forName(Constant.ENTITY_PATH + entry.getKey());
                    if (attrObjClass.isInstance(baSlsq)) { //SLSQ受理申请表中增加字段SQLX申请类型
                        Object obj = JaxbUtil.converyToJavaBean(str, attrObjClass, areaCode, "", "", "",fileName);
                        ywh = ((BaSlsq) obj).getYwh();
                        bz = ((BaSlsq) obj).getBz();
                        break;
                    }
                } catch (ClassNotFoundException e) {
                    LOGGER.error("ObjectServiceImpl.getObject ClassNotFoundException in！{}", e.getMessage());
                    throw new AppException(e, 2008);
                }
            }
        }

        String exchangeQxdm = XmlUtil.getExhangeQxdm(qxdm, bz);
        for (Map.Entry<String, List<String>> entry : datas.entrySet()) {
            List<String> allDatas = entry.getValue();
            for (String str : allDatas) {
                try {
                    Class attrObjClass = Class.forName(Constant.ENTITY_PATH + entry.getKey());
                    Object obj = JaxbUtil.converyToJavaBean(str, attrObjClass, areaCode, exchangeQxdm, bdcdyh, ywh,fileName);
                    if (obj instanceof BaSlsq) { //SLSQ受理申请表中增加字段SQLX申请类型
                        ((BaSlsq) obj).setSqlx(recType);
                        ((BaSlsq) obj).setBdcdyh(bdcdyh);
                    }
                    if (obj instanceof BaQlr) { //SLSQ受理申请表中增加字段SQLX申请类型
                        ((BaQlr) obj).setYwh(ywh);
                    }
                    if (obj instanceof BaDyiq) {
                        String xydqlrzjzh = ((BaDyiq) obj).getXydqlrzjzh();
                        ((BaDyiq) obj).setXydqlrzjh(xydqlrzjzh);
                    }
                    objects.add(obj);
                } catch (ClassNotFoundException e) {
                    LOGGER.error("ObjectServiceImpl.getObject ClassNotFoundException2 out!{}", e.getMessage());
                    throw new AppException(e, 2008);
                }
            }
        }
        return objects;
    }


    /**
     * 消息处理类
     */
    private static class ChangeXmlFormat {

        private ChangeXmlFormat() {
        }

        static Map<String, String> reflectData = new HashMap<>();
        static Map<String, String> reflectClass = new HashMap<>();

        private static void initData() {
            try {
                String reflectConfig = AppConfig.getProperty("supervise.reflect.config");
                if (reflectConfig == null) {
                    LOGGER.error("-----初始化reflect映射文件未找到异常!---");
                }
                String s = FileUtil.getFileString(new File(reflectConfig));
                getElementProperty(s);
            } catch (DocumentException e) {
                LOGGER.error("ChangeXmlFormat.initData DocumentException in！{}", e.getMessage());
                throw new AppException(e, 2005);
            }

        }

        /**
         * @param fileContent   需要装换的字符串
         * @param parentElement 父节点
         * @return 可以通过xml工具转换的字符串
         * @throws
         * @description 提取XML<DATA> 节点中的数据并将属性名称转为小写 xml转换为bean工具的需要 并将数据通过map返回给调用方
         */
        private static Map<String, List<String>> getParamValueByElement(String fileContent, String parentElement, String fileName) {
            Map<String, List<String>> data = new HashMap<>();
            try {
                initData();
                Document doc;
                Element sonElement;
                Document sonDoc;
                String className;
                String elementName;
                doc = DocumentHelper.parseText(fileContent);
                Element root = doc.getRootElement();
                Element son = root.element(parentElement);
                List<Element> elements = son.elements();
                for (Element e : elements) {
                    elementName = e.getName();
                    boolean flag = reflectData.containsKey(elementName);
                    if (!flag) {
                        LOGGER.info("提示信息：文件名称为: " + fileName + ",尝试转换节点: " + elementName + "失败,请确认。");
                    }
                    if (flag) {
                        className = (reflectData.get(elementName) == null ? elementName : reflectData.get(elementName));
                        sonElement = DocumentHelper.createElement(className);
                        List<Attribute> attributes = e.attributes();
                        for (Attribute attr : attributes) {
                            sonElement.setAttributeValue(attr.getName().toLowerCase(), attr.getText());
                        }
                        sonDoc = DocumentHelper.createDocument(sonElement);
                        String s = sonDoc.asXML();
                        String key = reflectClass.get(className) == null ? className : reflectClass.get(className);
                        if (data.get(key) == null) {
                            List<String> strs = new ArrayList<>();
                            strs.add(s);
                            data.put(key, strs);
                        } else {
                            data.get(key).add(s);
                        }
                    }
                }
            } catch (DocumentException e) {
                LOGGER.error("ChangeXmlFormat.getParamValueByElement DocumentException in！{}", e.getMessage());
                throw new AppException(e, 2005);
            }
            return data;
        }


        public static void getElementProperty(String fileContent) throws DocumentException {
            Document doc;
            doc = DocumentHelper.parseText(fileContent);
            String key = null;
            String value = null;
            String middle;
            Element root = doc.getRootElement();
            List<Element> list = root.elements();
            for (Element e : list) {
                List<Attribute> attributes = e.attributes();
                for (Attribute attr : attributes) {
                    if (Constant.NODE_NAME.equalsIgnoreCase(attr.getName().toLowerCase())) {
                        key = attr.getText();
                    }
                    if (Constant.CLASS_NAME.equalsIgnoreCase(attr.getName().toLowerCase())) {
                        value = attr.getText();
                    }
                }
                middle = changeKey(value);
                reflectData.put(key, middle);
                reflectClass.put(middle, value);
            }
        }

        private static String changeKey(String value) {
            String valueStr = value.substring(0, 1).toLowerCase() + value.substring(1);
            return valueStr;
        }
    }


    /**
     * 图形坐标参考检查,80坐标系数据检查，x坐标7位，y坐标8位
     *
     * @param content 需要转换的字符串
     * @return xml中对应的实体
     * @throws DocumentException
     * @throws ClassNotFoundException
     */
    public String getZbInfos(String content, String fileName) {
        Map<String, List<String>> datas = ChangeXmlFormat.getParamValueByElement(content, "Data", fileName);
        String xzb;
        String yzb;
        String resStr = "";
        for (Map.Entry<String, List<String>> entry : datas.entrySet()) {
            List<String> allDatas = entry.getValue();
            for (String str : allDatas) {
                try {
                    Class attrObjClass = Class.forName(Constant.ENTITY_PATH + entry.getKey());
                    Object obj = JaxbUtil.converyToJavaBean(str, attrObjClass, "", "", "", "",fileName);
                    if (obj instanceof BaZdk103) {
                        xzb = ((BaZdk103) obj).getXzb();
                        String tempXzb = xzb.substring(0, xzb.indexOf("."));
                        if (null != tempXzb && !tempXzb.isEmpty() && tempXzb.length() != 7) {

                            resStr = "X坐标校验失败";
                        }
                        yzb = ((BaZdk103) obj).getYzb();
                        String tempYzb = yzb.substring(0, yzb.indexOf("."));
                        if (null != tempYzb && !tempYzb.isEmpty() && tempYzb.length() != 8) {
                            resStr = (null != resStr && resStr.length() > 0) ? (resStr + "," + "Y坐标校验失败") : "Y坐标校验失败";
                        }
                    }
                    if (obj instanceof BaZhk105) {
                        xzb = ((BaZhk105) obj).getXzb();
                        String tempXzb = xzb.substring(0, xzb.indexOf("."));
                        if (null != tempXzb && !tempXzb.isEmpty() && tempXzb.length() != 7) {
                            resStr = "X坐标校验失败";
                        }

                        yzb = ((BaZhk105) obj).getYzb();
                        String tempYzb = yzb.substring(0, yzb.indexOf("."));
                        if (null != tempYzb && !tempYzb.isEmpty() && tempYzb.length() != 8) {
                            resStr = (null != resStr && resStr.length() > 0) ? (resStr + "," + "Y坐标校验失败") : "Y坐标校验失败";
                        }
                    }
                } catch (ClassNotFoundException e) {
                    LOGGER.error("ObjectServiceImpl.getZbInfos ClassNotFoundException4 in！{}", e);
                    throw new AppException(e, 2008);
                }
            }
        }

        return resStr;
    }


}
