package cn.gtmap.realestate.supervise.server.common.impl;

import cn.gtmap.estateplat.core.ex.AppException;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.realestate.supervise.entity.BaSlsq;
import cn.gtmap.realestate.supervise.entity.BaYgdj;
import cn.gtmap.realestate.supervise.model.FileMessage;
import cn.gtmap.realestate.supervise.model.MessageClient;
import cn.gtmap.realestate.supervise.model.MessageServer;
import cn.gtmap.realestate.supervise.model.Respond;
import cn.gtmap.realestate.supervise.server.config.Constant;
import cn.gtmap.realestate.supervise.server.dao.InsertRZJLDao;
import cn.gtmap.realestate.supervise.server.dao.mapper.*;
import cn.gtmap.realestate.supervise.server.entity.PublicRzJl;
import cn.gtmap.realestate.supervise.server.entity.Rzjl;
import cn.gtmap.realestate.supervise.server.es.SearchService;
import cn.gtmap.realestate.supervise.server.model.CheckResult;
import cn.gtmap.realestate.supervise.server.rabbitmq.SendMessage;
import cn.gtmap.realestate.supervise.server.rocketmq.ProducerMsg;
import cn.gtmap.realestate.supervise.server.service.MonitorService;
import cn.gtmap.realestate.supervise.server.service.ServeLog;
import cn.gtmap.realestate.supervise.server.service.impl.*;
import cn.gtmap.realestate.supervise.server.sftp.SftpService;
import cn.gtmap.realestate.supervise.server.sftp.WatchDirService;
import cn.gtmap.realestate.supervise.server.socket.SocketHandler;
import cn.gtmap.realestate.supervise.server.utils.BeanUtils;
import cn.gtmap.realestate.supervise.server.utils.FileUtils;
import cn.gtmap.realestate.supervise.server.utils.TimeUtils;
import cn.gtmap.realestate.supervise.server.utils.XmlUtil;
import cn.gtmap.realestate.supervise.utils.JaxbUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.config.AppConfig;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.web.socket.TextMessage;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.*;


/**
 * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
 * @version 1.0, 2017/6/6
 * @description 数据插入服务
 */
@Service
public class DataInsertDbService implements ApplicationContextAware {

    //报省开关
    public static final String isUploadProvice = AppConfig.getProperty("isUploadProvice");
    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @description 是否上报部开关
     */
    public static final String isUpload = AppConfig.getProperty("isUpload");
    /**
     * 消息发送目的地名称
     */
    public static final String desName = AppConfig.getProperty("supervise.des.name");
    private static final Logger LOGGER = LoggerFactory.getLogger(DataInsertDbService.class);

    //接入报文队列前缀
//    private static final String JRBWQUEUE = "jrbw_";
    //报文入库队列前缀
    private static final String BWRKQUEUE = "bwrk_";

    /**
     * 上报文件备份路径
     */
    String sftpBizBakPath = AppConfig.getProperty("supervise.sftp.biz.bak.path");
    /**
     * 上报省，文件备份路径
     */
    String sftpProvinceBizBakPath = AppConfig.getProperty("supervise.sftp.province.biz.path");
    String qxdm = AppConfig.getProperty("supersive.server.qhdm");//需要转换的区划代码
    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @description 发送消息工具
     */
    SendMessage sendMessage;

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @description 服务工厂
     */
    @Autowired
    ServeFactory serveFactory;


    @Autowired
    SftpService sftpService;

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @description 插入日志工具
     */
    @Autowired
    InsertRZJLDao insertRZJLDao;

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @description 验证工具代理
     */
    @Autowired
    CheckMessageProxy checkMessageProxy;

    @Autowired
    SearchService searchService;


    @Autowired
    XzqhInfoServiceImpl xzqhInfoService;

    @Autowired
    MonitorService monitorService;

    @Autowired
    WatchDirService watchDirService;

    @Autowired
    BaRzjlMapper baRzjlMapper;

    @Autowired
    BaXzqhMapper baXzqhMapper;

    @Autowired
    ObjectServiceImpl objectService;

    @Autowired
    EntityMapper entityMapper;
    @Autowired
    BwcxrkMapper bwcxrkMapper;
    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @description 验证结果封装对象
     */
    List<CheckResult> results = new ArrayList<>();
    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @description 日志记录管理工具
     */
    @Autowired
    RzjlManageService rzjls;
    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @description 需要处理的客户端信息封装类
     */
    MessageClient messageClient;
    ProducerMsg producerMsg;


    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @description 接入点名称
     */
//    private String jrdmc;
    @Autowired
    private BaSftpMapper baSftpMapper;
    @Autowired
    private CheckRepeatService checkRepeatService;
    @Autowired
    private SaveHistoryMaterialInfoServiceImpl saveHistoryMaterialInfoService;
    @Autowired
    private DataDetailCheck dataDetailCheck;
    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @description 验证返回结果
     */
    private List resList;
    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @description 验证成功的文件
     */
    private List<FileMessage> fittleMessages = new ArrayList<>();
    /**
     * 是否校验重复上报
     */
    @Value("${supervise.Repeat.Upload}")
    private String checkRepeatUploadFlag;

    @Autowired
    private Environment env;

    //上下文变量
    private ApplicationContext applicationContext;

    /**
     * @param fileMessages 需要过滤的所有文本文件
     * @param results      需要去除的文本文件，验证阶段没有通过
     * @return 可以执行插入的所有文件
     */
    private static List<FileMessage> filterByCheckResult(List<FileMessage> fileMessages, List<CheckResult> results) {
        Iterator it = fileMessages.iterator();
        if (results != null && !results.isEmpty()) {
            while (it.hasNext()) {
                FileMessage file = (FileMessage) it.next();
                for (CheckResult result : results) {
                    if (file.getFileName().equals(result.getFileMessage().getFileName())) {
                        it.remove();
                    }
                }
            }
        }

        return fileMessages;
    }

    /**
     * @throws UnsupportedEncodingException
     */
    public void dataHandle() throws UnsupportedEncodingException {
        MessageClient messageClientTemp = getMessageClient();
        String jrdmc = messageClientTemp.getServerName();
        String jrddm = messageClientTemp.getForm();
        boolean flag = true;
        //服务端接收报文保存ES
        List<FileMessage> fileMessageList = messageClientTemp.getMessageContents();
        String fileId = UUIDGenerator.generate18();
        String fileName = "";
        FileMessage fileMessageTemp = null;
        if (null != fileMessageList && !fileMessageList.isEmpty()) {
            Map<String, Object> jsonStr = new HashMap<>();
            for (FileMessage fileMessage : fileMessageList) {
                fileMessageTemp = fileMessage;
                fileName = fileMessage.getFileName();
                String result = fileMessage.getResult();
                jsonStr.put("fileName", fileName);
                jsonStr.put("message", new String(fileMessage.getContent(), "UTF-8"));
                jsonStr.put("dataTime", TimeUtils.dateToStr(new Date(), "yyyy-MM-dd HH:mm:ss"));
                jsonStr.put("fileId", fileId);
                messageClientTemp.setFileId(fileId);
                searchService.mainCreateIndex(jsonStr, "");
                if (null != result && !"true".equalsIgnoreCase(result)) {
                    flag = false;
                }
            }
        }

        if (flag) {
            CheckResultManage back = checkMessageProxy.checkMessageTemplate(messageClientTemp);
            if (back != null) {
                results = back.getResults();
            }
        } else {
            flag = true;
            CheckResult checkResult = new CheckResult();
            FileMessage fileMessage = new FileMessage();
            if (null != fileMessageList && !fileMessageList.isEmpty()) {
                fileMessage = fileMessageList.get(0);
            }
            String result = fileMessage.getResult();
            List<String> errors = new ArrayList<>();
            String respCode = XmlUtil.getTextByXpath("/respond/ResponseCode", result);
            String respInfo = XmlUtil.getTextByXpath("/respond/ResponseInfo", result);
            errors.add(respCode + ":" + respInfo);
            checkResult.setFileMessage(fileMessage);
            checkResult.setErrors(errors);
            results.add(checkResult);
        }


        LOGGER.info("服务端接收报文成功：{}，初始化日志记录", fileName);
        /**
         * 验证成功消息进行入库处理
         */
        fittleMessages = filterByCheckResult(messageClientTemp.getMessageContents(), results);
        if (CollectionUtils.isNotEmpty(results)) {
            rzjls.initRzjl(fileId, fileName, fileMessageTemp, jrddm, jrdmc, results.get(0));//初始化日志
        } else {
            rzjls.initRzjl(fileId, fileName, fileMessageTemp, jrddm, jrdmc, fileMessageTemp);//初始化日志
        }
        //改造之后、先返回响应报文
        sendMessageToClient(results, messageClientTemp, fittleMessages);

    }

    /**
     * @param changResults 已经转换的文件和响应消息的集合
     */
    private void sendMessageByResults(Map<FileMessage, Respond> changResults, List<CheckResult> results, String ywbwid) {

        if (null != changResults && !changResults.isEmpty()) {
            Respond responseMessage;
            FileMessage fileMessage;
            MessageServer messageServer = new MessageServer();
            for (Map.Entry<FileMessage, Respond> entry : changResults.entrySet()) {
                responseMessage = entry.getValue();
                String respCode = responseMessage.getResponseCode();
                if (null != results && !results.isEmpty()) {
                    String responseInfo = results.toString();
                    responseMessage.setResponseInfo(responseInfo);
                    List<String> errorStrings = results.get(0).getErrors();
                    String errorStr = errorStrings.get(0);
                    respCode = errorStr.substring(0, errorStr.indexOf(":"));
                    responseMessage.setResponseCode(respCode);
                }
                fileMessage = entry.getKey();
                String resInfo = JaxbUtil.convertToXml(responseMessage, "UTF-8");
                if ("0000".equals(responseMessage.getResponseCode())) {
                    messageServer.setResult(true);
                } else {
                    messageServer.setResult(false);
                }
                //改造之后响应报文保存到ES
                String fileName = fileMessage.getFileName().replace("Biz", "Rep");
                saveResInfoToEs(resInfo, fileName, respCode, ywbwid);
                //发送区县端入库结果
                JSONObject resJson = new JSONObject();
                resJson.put("msg", resInfo);
                resJson.put("code", responseMessage.getResponseCode());
                sendMsgRkjg(getEnv(), resJson, fileMessage.getAreaCode(),fileName);
            }
        }
    }

    //入库结果反馈 发送Mq
    private void sendMsgRkjg(boolean envFlag, JSONObject resInfo, String areaCode, String RepFileName) {
        resInfo.put("type", "rkjg");
        if (envFlag) {
            if (null == producerMsg) {
                producerMsg = getApplicationContext().getBean(ProducerMsg.class);
            }
            producerMsg.sendMsg(resInfo.toJSONString(), areaCode, RepFileName);
        } else {
            if (null == sendMessage) {
                sendMessage = getApplicationContext().getBean(SendMessage.class);
            }
            sendMessage.sendDirectMsg(resInfo.toJSONString(), BWRKQUEUE+areaCode);
        }
    }

    //接入情况反馈 发送Mq
    private void sendMsgJrqk(boolean envFlag, JSONObject resInfo, String areaCode, String RepFileName) {
        resInfo.put("type", "jrqk");
        if (envFlag) {
            if (null == producerMsg) {
                producerMsg = getApplicationContext().getBean(ProducerMsg.class);
            }
            producerMsg.sendMsg(resInfo.toJSONString(), areaCode, RepFileName);
        } else {
            if (null == sendMessage) {
                sendMessage = getApplicationContext().getBean(SendMessage.class);
            }
            sendMessage.sendDirectMsg(resInfo.toJSONString(), BWRKQUEUE+areaCode);
        }
    }



    /**
     * @param allResults 文件和日志文件的Map集合
     * @return
     * @throws IOException 根据FileMessage和日志文件实现了返回报文的封装
     */
    private Map<FileMessage, Respond> getResponseMessage(Map<FileMessage, Rzjl> allResults) {
        Map<FileMessage, Respond> results = new HashMap<>();
        Respond responseMessage;
        for (Map.Entry<FileMessage, Rzjl> entry : allResults.entrySet()) {
            FileMessage fileMessage = entry.getKey();
            responseMessage = new Respond();
            responseMessage.setSuccessFlag(Constant.CODE_1);
            responseMessage.setCertID("");
            responseMessage.setBizMsgID(fileMessage.getBizMsgId());
            responseMessage.setAdditionalData2("");
            responseMessage.setAdditionalData("");
            responseMessage.setQRCode("");
            responseMessage.setResponseInfo(Constant.XXCGCL);
            responseMessage.setResponseCode(Constant.SUCCESS_CODE);
            Rzjl rzjl = entry.getValue();
            String bwjcjg = rzjl.getBwjcjg();
            String sjrukcz = rzjl.getSjrkcz();
            if (bwjcjg.contains(Constant.CODE_2020)) {
                responseMessage.setSuccessFlag(Constant.CODE_2);
                responseMessage.setResponseInfo(Constant.JSQMCW);
                responseMessage.setResponseCode(Constant.CODE_2020);
            }
            if (bwjcjg.contains(Constant.CODE_1000)) {
                responseMessage.setSuccessFlag(Constant.CODE_2);
                responseMessage.setResponseInfo(Constant.SJJYCW);
                responseMessage.setResponseCode(Constant.CODE_1000);
            }
            if (Constant.SUCCESS.equals(bwjcjg) && !Constant.SUCCESS_CODE.contains(sjrukcz)) {
                if (null != resList && !resList.isEmpty()) {
                    String respInfo = resList.get(0).toString();
                    if (respInfo.contains("]")) {
                        responseMessage.setResponseInfo(respInfo.substring(respInfo.indexOf(":") + 1, respInfo.indexOf("]")));
                    } else {
                        responseMessage.setResponseInfo(respInfo.substring(respInfo.indexOf(":") + 1));
                    }
                } else {
                    responseMessage.setResponseInfo(Constant.SJRKSB);
                }
                responseMessage.setSuccessFlag(Constant.CODE_2);
                responseMessage.setResponseCode(Constant.CODE_0001);
            }
            if (Constant.SUCCESS.equals(bwjcjg) && Constant.SUCCESS_CODE.equals(sjrukcz)) {
                responseMessage.setSuccessFlag(Constant.CODE_1);
                responseMessage.setResponseInfo(Constant.CGRK);
                responseMessage.setResponseCode(Constant.SUCCESS_CODE);
            }
            if (Constant.SUCCESS.equals(bwjcjg) && Constant.ERROR_CODE2.equals(sjrukcz)) {
                responseMessage.setSuccessFlag(Constant.CODE_2);
                responseMessage.setResponseInfo(Constant.KHDJYCW);
                responseMessage.setResponseCode(Constant.ERROR_CODE2);
            }
            results.put(fileMessage, responseMessage);
        }
        return results;

    }

    /**
     * @param recMessage 服务端接受到客户端发出的消息
     *                   将rec_message 进行验证处理入库的流程并返回操作结果
     */
    public void messageService(MessageClient recMessage) {

        List<FileMessage> fileMessages = recMessage.getMessageContents();
        String khdbm = recMessage.getForm();
        String jrddm = recMessage.getForm();
        String jrdmc = recMessage.getServerName();
        String fileId = recMessage.getFileId();//报文存入es中的ID
        for (int i = 0; i < fileMessages.size(); i++) {
            FileMessage messageContent = fileMessages.get(i);
            String fileName = messageContent.getFileName();
            try {
                byte[] bytes = messageContent.getContent();
                if (null == bytes || bytes.length <= 0) {
                    continue;
                }
                BaSlsq baSlsqList = serviceCheck(messageContent);//校验业务报文是否相同
                if (null != baSlsqList) {
                    delBwxx(fileName, messageContent);//根据业务报文内容删除数据
                }
                LOGGER.info("报文开始入库:{}", fileName);

                ServeLog serveLog = serveFactory.serveDetail(messageContent);
                List listLogs = serveLog.getErrors();
                LOGGER.info("报文结束入库:{}", fileName);

                if (null != listLogs && !listLogs.isEmpty()) {
                    rzjls.insertRzjl(messageContent, "0001", "失败", "", jrddm, jrdmc, fileId);
                    resList = new ArrayList<>();
                    resList.add(serveLog.getErrors().toString());
                    serveLog.getErrors().clear();
                } else {
                    LOGGER.info("报文准备上报开始:{}", fileName);
                    boolean checkUploadable = this.checkRepeatUpload(messageContent.getEstateNum());
                    if (!checkUploadable) {
                        return;
                    }

                    //报省、双上报使用
                    uploadProvinceSftpXml(messageContent);

                    //记录日志&上报
                    rzjls.insertRzjl(messageContent, "0000", "成功", khdbm, jrddm, jrdmc, fileId);

                    LOGGER.info("报文准备上报结束:{}", fileName);
                }
            } catch (Exception e) {
                LOGGER.error("messageService.Exception!{}", e);
            }
        }
    }

    public MessageClient getMessageClient() {
        return messageClient;
    }

    public void setMessageClient(MessageClient messageClient) {
        this.messageClient = messageClient;
    }


    /**
     * 返回响应报文给客户端
     *
     * @param checkResultList
     * @param recMessage
     * @param fileMessageList
     */
    public void sendMessageToClient(List<CheckResult> checkResultList, MessageClient recMessage, List<FileMessage> fileMessageList) {
        MessageServer messageServer = new MessageServer();
        Respond responseMessage;

        boolean envFlag = getEnv();

        //校验失败报文
        if (null != checkResultList && !checkResultList.isEmpty()) {

            for (CheckResult result : checkResultList) {
                FileMessage filemessage = result.getFileMessage();
                String fileName = filemessage.getFileName();
                List<String> errorsList = result.getErrors();
                String errorInfo = errorsList.get(0);
                String errorCode = errorInfo.substring(0, errorInfo.indexOf(':'));
                responseMessage = new Respond();
                responseMessage.setSuccessFlag("2");
                responseMessage.setCertID("");
                responseMessage.setBizMsgID(filemessage.getBizMsgId());
                responseMessage.setAdditionalData2("");
                responseMessage.setAdditionalData("");
                responseMessage.setQRCode("");
                responseMessage.setResponseInfo(result.toString());
                responseMessage.setResponseCode(errorCode);
                responseMessage.setServerName(recMessage.getServerName());
                responseMessage.setFileName(fileName);
                responseMessage.setAreaCode(filemessage.getAreaCode());
                String resInfo = JaxbUtil.convertToXml(responseMessage, "UTF-8");
                messageServer.setPath(filemessage.getPath());
                messageServer.setServerName(recMessage.getServerName());
                messageServer.setBackInfo(resInfo);
                messageServer.setResponseMessage(responseMessage);
                messageServer.setServerQueue(recMessage.getServerName());
                String RepFileName = fileName.replace("Biz", "Rep");
                sendMsg(envFlag, messageServer, recMessage,RepFileName);
            }
        }
        //校验成功报文
        if (null != fileMessageList && !fileMessageList.isEmpty()) {
            for (int i = 0; i < fileMessageList.size(); i++) {
                FileMessage fileMessage = fileMessageList.get(i);
                byte[] bytes = fileMessage.getContent();
                if (null == bytes || bytes.length <= 0) {
                    continue;
                }
                String fileName = fileMessage.getFileName();
                responseMessage = new Respond();
                responseMessage.setSuccessFlag("1");
                responseMessage.setCertID("");
                responseMessage.setBizMsgID(fileMessage.getBizMsgId());
                responseMessage.setAdditionalData2("");
                responseMessage.setAdditionalData("");
                responseMessage.setQRCode("");
                responseMessage.setResponseInfo("消息成功处理");
                responseMessage.setResponseCode("0000");
                responseMessage.setServerName(recMessage.getServerName());
                responseMessage.setFileName(fileName);
                responseMessage.setAreaCode(fileMessage.getAreaCode());
                String resInfo = JaxbUtil.convertToXml(responseMessage, "UTF-8");
                messageServer.setPath(fileMessage.getPath());
                messageServer.setServerName(recMessage.getServerName());
                messageServer.setBackInfo(resInfo);
                messageServer.setResponseMessage(responseMessage);
                messageServer.setServerQueue(recMessage.getServerName());
                String RepFileName = fileName.replace("Biz", "Rep");
                sendMsg(envFlag, messageServer, recMessage,RepFileName);
            }
        }
    }

    /**
     *
     */
//    @Async("taskExecutorService")
    public void serviceHandle() {

        MessageClient recMessageTemp = getMessageClient();
        String ywbwid = recMessageTemp.getFileId();
        /**
         * 检测xml文件是否合法
         */
        if (null != results && !results.isEmpty()) {
            String jrddm = recMessageTemp.getForm();
            String jrdmc = recMessageTemp.getServerName();
            for (CheckResult result : results) {
                rzjls.insertRzjl(result, "验证未通过", "失败", "", jrddm, jrdmc, ywbwid);
            }
        }

        if (checkMessageProxy.iserrorMessage()) {
            Map<FileMessage, Respond> failInfo = getResponseMessage(rzjls.getAllResults());
            try {
                sendMessageByResults(failInfo, results, ywbwid);
                if (null != fittleMessages && !fittleMessages.isEmpty()) {
                    fittleMessages.clear();
                }

                if (null != results && !results.isEmpty()) {
                    results.clear();
                }
            } catch (Exception e) {
                LOGGER.error("DataInsertDbService.dataHandle Exception in!{}", e);
            }
            return;
        }

        try {
            if (null != fittleMessages && !fittleMessages.isEmpty()) {
                recMessageTemp.setMessageContents(fittleMessages);
                messageService(recMessageTemp);//报文业务逻辑处理入口
            }
        } catch (Exception e) {
            LOGGER.error("DataInsertDbService.dataHandle Exception in!{}", e);
        } finally {

            Map<FileMessage, Rzjl> allResults = null;
            if (null != rzjls) {
                allResults = rzjls.getAllResults();
            }
            /**
             * 根据返回的反馈报文和消息进行文件生成和发送消息
             */
            Map<FileMessage, Respond> changeResults = null;
            if (null != allResults) {
                changeResults = getResponseMessage(allResults);
            }

            /**
             * 消息的最终处理，给客户端发送提示消息，本地存储报文文件和响应报文文件
             */
            try {
                sendMessageByResults(changeResults, results, ywbwid);
            } catch (Exception e) {
                LOGGER.error("DataInsertDbService.dataHandle Exception in!{}", e);
                if (null != fittleMessages && !fittleMessages.isEmpty()) {
                    fittleMessages.clear();
                }

                if (null != results && !results.isEmpty()) {
                    results.clear();
                }
            }

            if (null != fittleMessages && !fittleMessages.isEmpty()) {
                fittleMessages.clear();
            }

            if (null != results && !results.isEmpty()) {
                results.clear();
            }
        }

    }

    /**
     * 保存响应报文到es
     *
     * @param resInfo
     * @param fileName
     */
    public void saveResInfoToEs(String resInfo, String fileName, String respCode, String ywbwid) {
        Map<String, Object> json = new HashMap<>();
        json.put("fileName", fileName);
        json.put("message", resInfo);
        json.put("respCode", respCode);
        json.put("fileId", ywbwid);
        searchService.mainCreateIndex(json, "");
    }


    /**
     * 接入首页websocket消息发送
     */
    public void sendSocketMessage(String jrxzqdm, String jrdmc) {
        Map<String, Object> map = new HashMap<>();
        map.put("from", jrdmc);
        map.put("jrxzqdm", jrxzqdm);
        map.put("des", desName);
        String qhdm = AppConfig.getProperty("region.qhdm");
        List<Map<String, Object>> dsxxList = baXzqhMapper.getDsxx(qhdm);//省级平台数据
        if (CollectionUtils.isEmpty(dsxxList)) {
            dsxxList = baXzqhMapper.getQxxxByFdm(qhdm);//市级平台数据
        }
        List<Map<String, Object>> jrsl = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(dsxxList)) {
            List<Map<String, Object>> allZjrl = xzqhInfoService.getHztjxx("");
            if (CollectionUtils.isNotEmpty(allZjrl)) {
                Map<String, Object> temp = Maps.newHashMap();
                String allzjrl = (String) allZjrl.get(0).get("ALLZJRL");
                String alldtjrl = (String) allZjrl.get(0).get("ALLDTJRL");
                temp.put("ALLZJRL", allzjrl);
                temp.put("DTJRL", alldtjrl);
                temp.put("QHDM", qhdm);
                jrsl.add(temp);
            }

            for (int i = 0; i < dsxxList.size(); i++) {
                Map<String, Object> temp = dsxxList.get(i);
                String qhmc = (String) temp.get("QHMC");
                String qhdmStr = (String) temp.get("QHDM");
                List<Map<String, Object>> tempJrsl = xzqhInfoService.getHztjxx(qhmc);
                if (CollectionUtils.isNotEmpty(tempJrsl)) {
                    Map<String, Object> tempMap = tempJrsl.get(0);
                    tempMap.put("QHDM", qhdmStr);
                    jrsl.add(tempMap);
                }
            }
        }

        List<Map<String, Object>> sbsl = xzqhInfoService.getSbData();
        map.put("jrsl", jrsl);
        map.put("sbsl", sbsl);
        String json = JSONObject.toJSONString(map);
        SocketHandler socketHandler = BeanUtils.getSystemWebSocketHandler();
        socketHandler.sendMessageToUsers(new TextMessage(json));
    }

    /**
     * 业务校验
     *
     * @param fileMessage
     * @return
     */
    public BaSlsq serviceCheck(FileMessage fileMessage) {
//        String qxdm = fileMessage.getAreaCode();//区划代码
//        String ywh = fileMessage.getRecFlowID();//业务号
//        String ywhStr = qxdm + "_" + ywh;
        String bdcdyh = fileMessage.getEstateNum();
        String ywh = getYwh(fileMessage);
        String recType = fileMessage.getRectype();

        String ygdjzl = getYgdjzl(fileMessage);

        List<BaSlsq> baSlsq;
        if (StringUtils.equals(recType, Constant.YGDJ) && StringUtils.isNotBlank(ygdjzl)) {
            baSlsq = bwcxrkMapper.getBaslsqByYwhYg(ywh, bdcdyh, ygdjzl);
        } else {
            baSlsq = bwcxrkMapper.getBaslsqByYwh(ywh, bdcdyh);
        }
        if (CollectionUtils.isNotEmpty(baSlsq)) {
            return baSlsq.get(0);
        }
        return null;
    }

    /**
     * 通过报文内容找到预告登记
     *
     * @param fileMessage
     * @return
     */
    private String getYgdjzl(FileMessage fileMessage) {
        String bdcdyh = fileMessage.getEstateNum();
        String recType = fileMessage.getRectype();

        String content = getContent(fileMessage);
        String areaCode = fileMessage.getAreaCode();
        List<Object> objects = getList(content, recType, fileMessage.getFileName(), areaCode, bdcdyh);
        for (int i = 0; i < objects.size(); i++) {
            Object obj = objects.get(i);
            if (obj instanceof BaYgdj) {
                return ((BaYgdj) obj).getYgdjzl();
            }
        }
        return null;
    }

    /**
     * 删除业务相同报文
     *
     * @param fileName
     * @param fileMessage
     */
    public void delBwxx(String fileName, FileMessage fileMessage) {
        String bdcdyh = fileMessage.getEstateNum();
        String content = XmlUtil.getContent(fileMessage);
        String recType = fileMessage.getRectype();
        String areaCode = fileMessage.getAreaCode();
        try {
            List<Object> objectList = objectService.getObject(content, recType, fileName, areaCode, bdcdyh);
            checkRepeatService.serveDetail(objectList);
            PublicRzJl publicRzJl = baSftpMapper.getSftpRzjlInfos(fileName);
            if (null != publicRzJl) {
                baSftpMapper.delBwInfos(publicRzJl.getId());
            }
        } catch (Exception e) {
            LOGGER.error("delBwxx.Exception!{},fileName:{}", e, fileName);
        }

    }

    /**
     * 保存历史信息
     *
     * @param fileName
     * @param fileMessage
     */
    public void saveHistoryBwxx(String fileName, FileMessage fileMessage) {
        String bdcdyh = fileMessage.getEstateNum();
        String content = XmlUtil.getContent(fileMessage);
        String recType = fileMessage.getRectype();
        String areaCode = fileMessage.getAreaCode();
        String ywh = fileMessage.getRecFlowID();
        try {
            List<Object> objectList = objectService.getObject(content, recType, fileName, areaCode, bdcdyh);
            saveHistoryMaterialInfoService.saveDetail(objectList, ywh);
        } catch (Exception e) {
            LOGGER.error("saveHistoryBwxx.Exception" + e);
        }
    }

    private boolean checkRepeatUpload(String bdcdyh) {
        boolean checkUploadable = false;

        if ("true".equals(checkRepeatUploadFlag)) {
            String ysdm = null;
            Date jssj = new Date();
            Date djsj = new Date();
            List<Map<String, Object>> BaQlrList = dataDetailCheck.getBaQlrByBdcdyh(bdcdyh);

            // 如果没有权利数据则可以上报
            if (BaQlrList.isEmpty()) {
                checkUploadable = true;
            } else {

                // 如果有权力人数据但是没有要素代码则可以上报
                if (BaQlrList.get(0).containsKey("ysdm")) {
                    ysdm = BaQlrList.get(0).get("ysdm").toString();
                    List<Map<String, Object>> baSlqsList = dataDetailCheck.getBaSlsqByYsdm(ysdm);

                    // 如果有权力人数据并且权利人记录有要素代码，但是没有受理记录或者受理记录没有接收时间则可以上报
                    if (!baSlqsList.isEmpty() && baSlqsList.get(0).containsKey("jssj")) {
                        jssj = (Date) baSlqsList.get(0).get("jssj");
                    } else {
                        checkUploadable = true;
                    }
                } else {
                    checkUploadable = true;
                }
            }

            // 如果受理接受时间大于登记时间，则不允许再上报
            if (StringUtils.isNotBlank(ysdm) && !checkUploadable) {
                List<Map<String, Object>> bafdcq2List = dataDetailCheck.getBaFdcq2ByYsdm(ysdm);
                if (!bafdcq2List.isEmpty()) {
                    djsj = (Date) bafdcq2List.get(0).get("djsj");
                }
            }
            if (jssj.after(djsj)) {
                checkUploadable = false;
            } else {
                checkUploadable = true;
            }
        } else {
            checkUploadable = true;
        }
        return checkUploadable;
    }


    /**
     * 报部
     *
     * @param messageContent
     * @param khdbm
     */
    public void uploadSftpXml(FileMessage messageContent, String khdbm, String bwid, String jrxzqdm) {

        boolean uploadFlag = false;
        boolean uoloadRzjlFlag = false;
        String fileName = messageContent.getFileName();
        Map<String, String> head = Maps.newHashMap();
        LOGGER.info("上报开始准备，方法开始前:{},isUpload:{}", fileName, isUpload);
        if ("true".equals(isUpload)) {
            LOGGER.info("上报开始准备，方法开始中:{}", fileName);
            try {
                String content = messageContent.toString();
                if (StringUtils.isNotBlank(content)) {
                    byte[] contentByte = content.getBytes("UTF-8");
                    String fileOldName = fileName + ".temp";
                    head = XmlUtil.getParamValueByElement(content, "Head");
                    FileUtils.saveFile(contentByte, sftpBizBakPath, fileOldName, fileName);//写文件
                    Map<String, Object> param = Maps.newHashMap();
                    String areaCode = head.get("AreaCode");
                    String exchangeQxdm = XmlUtil.getExhangeQxdm(qxdm, jrxzqdm);
                    if (StringUtils.isNotBlank(exchangeQxdm)) {
                        areaCode = exchangeQxdm;
                        head.put("AreaCode", areaCode);
                    }
                    param.put("bwxzqdm", areaCode);
                    String ywh = getYwh(messageContent);
                    String bdcdyh = messageContent.getEstateNum();
                    param.put("ywh", ywh);
                    param.put("bdcdyh", bdcdyh);
                    monitorService.synQxsbjkxx(param, fileName);// 区县上报情况数据同步
                    uoloadRzjlFlag = watchDirService.uploadFileRzjl(head, fileName, khdbm, ywh, bwid, jrxzqdm);//记录日志
                    uploadFlag = sftpService.sftpUploadXmlFile(fileName, content);//开始sftp上报
                }
            } catch (Exception e) {
                LOGGER.error("DataInsertDbService.uploadSftpXml exception!{},fileName:{}", e, fileName);
                if (uoloadRzjlFlag) {
                    watchDirService.updateSftpRzjlSbjg(head, fileName);
                }
            } finally {
                if (uploadFlag) {
                    LOGGER.info("上报成功，文件名:{}", fileName);
                } else {
                    watchDirService.updateSftpRzjlSbjg(head, fileName);
                    LOGGER.info("上报失败，文件名:{}", fileName);
                }
            }
        }
    }

    /**
     * 获取环境变量
     * rocketMQ true
     * rabbitMQ false
     *
     * @return
     */
    public boolean getEnv() {
        String[] envS = env.getActiveProfiles();
        if (null != envS && envS.length > 0) {
            String mqStr = envS[0];
            if (StringUtils.isNotBlank(mqStr) && StringUtils.equals(mqStr, "rocketMQ")) {
                return true;
            } else {
                return false;
            }
        }
        return false;
    }

    public void sendMsg(boolean envFlag, MessageServer messageServer, MessageClient recMessage, String RepFileName) {
        String fileId = recMessage.getFileId();
        if (envFlag) {
            if (null == producerMsg) {
                producerMsg = getApplicationContext().getBean(ProducerMsg.class);
            }
            rzjls.updateRzjlZt(fileId, Constant.CODE_1);
            producerMsg.sendMsg(JSON.toJSONString(messageServer), recMessage.getForm(), RepFileName);
            rzjls.updateRzjlZt(fileId, Constant.CODE_2);
        } else {
            if (null == sendMessage) {
                sendMessage = getApplicationContext().getBean(SendMessage.class);
            }
            rzjls.updateRzjlZt(fileId, Constant.CODE_1);
            sendMessage.sendDirectMsg(JSON.toJSONString(messageServer), recMessage.getQueueName());
            rzjls.updateRzjlZt(fileId, Constant.CODE_2);
        }
    }


    public ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    /**
     * 报省
     *
     * @param messageContent
     */
    public void uploadProvinceSftpXml(FileMessage messageContent) {
        boolean uploadFlag = false;
        boolean uploadSbjg = false;
        String fileName = messageContent.getFileName();
        if ("true".equals(isUploadProvice)) {
            LOGGER.info("上报省里准备开始，方法开始前:{},isUpload:{}", fileName, isUploadProvice);
            LOGGER.info("上报省里开始，方法开始中:{}", fileName);
            try {
                String content = messageContent.toString();
                if (StringUtils.isNotBlank(content)) {
                    byte[] contentByte = content.getBytes("UTF-8");
                    String fileOldName = fileName + ".temp";
                    FileUtils.saveFile(contentByte, sftpProvinceBizBakPath, fileOldName, fileName);//写文件
                    uploadSbjg = updateBscg(fileName); //报省成功
                    uploadFlag = sftpService.uploadProvinceSftpXml(fileName, content);//开始sftp报省
                }
                //发送mq
                if (uploadFlag) {
                    repUplodSftp(messageContent.getBizMsgId(), messageContent.getAreaCode(), Constant.XXBSCG, Constant.SUCCESS_CODE, Constant.CODE_1,fileName);
                } else {
                    repUplodSftp(messageContent.getBizMsgId(), messageContent.getAreaCode(), Constant.XXBSSB, Constant.ERROR_CODE2, Constant.CODE_2,fileName);
                }
            } catch (Exception e) {
                LOGGER.error("报省exception!{},fileName:{}", e, fileName);
                //报省失败 发送Mq
                repUplodSftp(messageContent.getBizMsgId(), messageContent.getAreaCode(), Constant.XXBSSB, Constant.ERROR_CODE2, Constant.CODE_2,fileName);
                if (uploadSbjg) {
                    updateBssb(fileName);//报省失败
                }
            } finally {
                if (uploadFlag) {
                    LOGGER.info("上报省里成功，文件名:{}", fileName);
                }
            }
        }
    }


    //报省反馈 区县
    private void repUplodSftp(String bizId, String qxdm, String xxbscg, String code, String flag, String fileName) {
        Respond responseMessage = new Respond();
        responseMessage.setSuccessFlag(flag);
        responseMessage.setCertID("");
        responseMessage.setBizMsgID(bizId);
        responseMessage.setAdditionalData2("");
        responseMessage.setAdditionalData("");
        responseMessage.setQRCode("");
        responseMessage.setResponseInfo(xxbscg);
        responseMessage.setResponseCode(code);
        String resInfo = JaxbUtil.convertToXml(responseMessage, "UTF-8");
        JSONObject resJson = new JSONObject();
        resJson.put("msg", resInfo);
        resJson.put("code", code);
        String RepFileName = fileName.replace("Biz", "Rep");
        sendMsgJrqk(getEnv(), resJson, qxdm,RepFileName);
    }

    /**
     * 报省成功日志处理
     *
     * @param fileName
     * @return
     */
    public boolean updateBscg(String fileName) {

        boolean flag = true;
        try {
            baSftpMapper.updateBscg(fileName);
        } catch (Exception e) {
            flag = false;
            LOGGER.error("updateBscg:{}", e);
        }
        return flag;
    }


    /**
     * 报省失败日志处理
     *
     * @param fileName
     * @return
     */
    public boolean updateBssb(String fileName) {
        boolean flag = true;
        try {
            baSftpMapper.updateBssb(fileName);
        } catch (Exception e) {
            flag = false;
            LOGGER.error("updateBssb:{}", e);
        }
        return flag;
    }


    /**
     * 根据报文内容获取业务号字段信息
     *
     * @param fileMessage
     * @return
     */
    public String getYwh(FileMessage fileMessage) {
        String fileName = fileMessage.getFileName();
        String bdcdyh = fileMessage.getEstateNum();
        String content = XmlUtil.getContent(fileMessage);
        String recType = fileMessage.getRectype();
        String areaCode = fileMessage.getAreaCode();
        String ywh = fileMessage.getRecFlowID();
        try {
            List<Object> objectList = objectService.getObject(content, recType, fileName, areaCode, bdcdyh);
            if (CollectionUtils.isNotEmpty(objectList)) {
                for (Object object : objectList) {
                    if (object instanceof BaSlsq) { //SLSQ受理申请表中增加字段SQLX申请类型
                        ywh = ((BaSlsq) object).getYwh();
                        break;
                    }
                }
            }
        } catch (Exception e) {
            LOGGER.error("获取业务号数据异常,文件名:{},异常信息:{}", fileName, e);
        }
        return ywh;
    }


    /**
     * fileMessage 转换成String
     *
     * @param fileMessage
     * @return
     */
    public String getContent(FileMessage fileMessage) {

        String contentStr = null;
        try {
            contentStr = new String(fileMessage.getContent(), "UTF-8");
        } catch (UnsupportedEncodingException e) {
            LOGGER.error("AbstractServeDetail.getContent UnsupportedEncodingException in !{}", e.getMessage());
            throw new AppException(e, 2002);
        }
        return contentStr;

        //将String装换为对象
    }

    /**
     * String 转换成List
     *
     * @param content
     * @return
     */
    public List<Object> getList(String content, String recType, String fileName, String areaCode, String bdcdyh) {

        //将String装换为对象
        List<Object> objs = objectService.getObject(content, recType, fileName, areaCode, bdcdyh);
        return objs;
    }

}
